/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAbstractAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAbstractPredefinedAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAnyAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentArgument;
import oracle.bpm.project.io.serializers.model.albpm.PersistentArrayAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAttributes;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBeginCode;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBinaryAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBoolAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentComponent;
import oracle.bpm.project.io.serializers.model.albpm.PersistentComponentException;
import oracle.bpm.project.io.serializers.model.albpm.PersistentComponentExceptions;
import oracle.bpm.project.io.serializers.model.albpm.PersistentComponentVariable;
import oracle.bpm.project.io.serializers.model.albpm.PersistentComponentVariables;
import oracle.bpm.project.io.serializers.model.albpm.PersistentDecimalAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentDocumentation;
import oracle.bpm.project.io.serializers.model.albpm.PersistentDocumentations;
import oracle.bpm.project.io.serializers.model.albpm.PersistentEndCode;
import oracle.bpm.project.io.serializers.model.albpm.PersistentEnsure;
import oracle.bpm.project.io.serializers.model.albpm.PersistentEnsures;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFeatureSet;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFieldMapping;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFieldMappings;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFirstPredefinedAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentInputArgument;
import oracle.bpm.project.io.serializers.model.albpm.PersistentIntegerAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentIntegrityCheck;
import oracle.bpm.project.io.serializers.model.albpm.PersistentIntegrityChecks;
import oracle.bpm.project.io.serializers.model.albpm.PersistentIntervalAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentIteratorAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentMapAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentMethod;
import oracle.bpm.project.io.serializers.model.albpm.PersistentMethodArguments;
import oracle.bpm.project.io.serializers.model.albpm.PersistentMethods;
import oracle.bpm.project.io.serializers.model.albpm.PersistentNullAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentObjectAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentObjectTypeDescriptionComponent;
import oracle.bpm.project.io.serializers.model.albpm.PersistentOutputArgument;
import oracle.bpm.project.io.serializers.model.albpm.PersistentProperties;
import oracle.bpm.project.io.serializers.model.albpm.PersistentReadCode;
import oracle.bpm.project.io.serializers.model.albpm.PersistentRealAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentRequire;
import oracle.bpm.project.io.serializers.model.albpm.PersistentRequires;
import oracle.bpm.project.io.serializers.model.albpm.PersistentStringAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentTimeAttribute;
import oracle.bpm.project.io.serializers.model.albpm.PersistentTransformation;
import oracle.bpm.project.io.serializers.model.albpm.PersistentTransformationSource;
import oracle.bpm.project.io.serializers.model.albpm.PersistentTransformationSources;
import oracle.bpm.project.io.serializers.model.albpm.PersistentTransformations;
import oracle.bpm.project.io.serializers.model.albpm.PersistentWriteCode;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeWriter;
import oracle.bpm.type.Validation;
import oracle.bpm.type.Variable;
import oracle.bpm.util.documentation.DocumentationType;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xmlparser.Element;

public class ObjectTypeDescriptionVisitor {
    private PersistentObjectTypeDescriptionComponent persistentOTD;

    public ObjectTypeDescriptionVisitor(PersistentObjectTypeDescriptionComponent persistentOTD) {
        this.persistentOTD = persistentOTD;
    }

    public static PersistentComponent createOldComponent(ObjectTypeDescription otd) throws IOException {
        StringWriter out = new StringWriter();
        XmlWriter xml = new XmlWriter((Writer)out, Literals.DEFAULT_ENCODING);
        xml.setIndentAttributes(true);
        TypeWriter.writeXml((XmlWriter)xml, (ObjectTypeDescription)otd);
        xml.close();
        PersistentComponent component = new PersistentComponent();
        component.setText(out.toString());
        return component;
    }

    public static ObjectTypeDescription createObjectTypeDescriptionFromOldXml(String xml) {
        return null;
    }

    protected void visit(ObjectTypeDescription otd) {
        this.visitComponentHeader(otd);
        this.visitComponentProperties(otd);
        this.visitComponentAttributes(otd);
        this.visitComponentMethods(otd);
        this.visitComponentTransformations(otd);
        this.visitComponentDocumentation(otd);
        this.visitComponentPresentations(otd);
    }

    private void visitComponentDocumentation(ObjectTypeDescription otd) {
        PersistentDocumentations persistentDocs = this.persistentOTD.getDocumentations();
        if (persistentDocs == null) {
            persistentDocs = new PersistentDocumentations();
        }
        this.visitDocumentations(persistentDocs, (TypeDescription)otd);
        if (!persistentDocs.isEmpty()) {
            this.persistentOTD.setDocumentations(persistentDocs);
        }
    }

    private void visitDocumentations(PersistentDocumentations persistentDocs, TypeDescription td) {
        for (DocumentationType type : DocumentationType.values()) {
            LocaleStringMap languages = td.getDocumentation(type);
            for (Map.Entry entry : languages.entrySet()) {
                PersistentDocumentation persistentDocumentation = new PersistentDocumentation();
                persistentDocumentation.setType(type.name());
                persistentDocumentation.setLanguage(((Locale)entry.getKey()).getLanguage());
                persistentDocumentation.setDocumentationString(Str.escape((String)((String)entry.getValue())));
                Str.toXMLString((String)((String)entry.getValue()));
                persistentDocs.addDocumentation(persistentDocumentation);
            }
        }
    }

    private void visitComponentPresentations(ObjectTypeDescription otd) {
    }

    private void visitComponentTransformations(ObjectTypeDescription otd) {
        MethodTypeDescription[] transformations = otd.getMembers(20);
        if (transformations.length > 0) {
            PersistentTransformations persistentTransformations = this.persistentOTD.getTransformations();
            if (persistentTransformations == null) {
                persistentTransformations = new PersistentTransformations();
                this.persistentOTD.setTransformations(persistentTransformations);
            }
            for (MethodTypeDescription transformation : transformations) {
                this.visitComponentTransformation(persistentTransformations, transformation);
            }
        }
    }

    private void visitComponentTransformation(PersistentTransformations persistentTransformations, MethodTypeDescription otd) {
        PersistentTransformation persistentTransformation = new PersistentTransformation();
        TransformTypeDescription transformTypeDescription = (TransformTypeDescription)otd;
        persistentTransformation.setName(transformTypeDescription.getName());
        persistentTransformation.setTargetType(transformTypeDescription.getTarget().getText());
        persistentTransformation.setTargetName(transformTypeDescription.getTargetName());
        this.visitComponentTransformationSources(transformTypeDescription, persistentTransformation);
        this.visitComponentTransformationFieldMappings(persistentTransformation, transformTypeDescription);
        this.visitComponentTransformationCodes(transformTypeDescription, persistentTransformation);
        this.visitComponentTransformationVariables(transformTypeDescription, persistentTransformation);
        persistentTransformations.addChild((Element)persistentTransformation);
    }

    private void visitComponentTransformationVariables(TransformTypeDescription transformTypeDescription, PersistentTransformation persistentTransformation) {
        if (transformTypeDescription.hasVariables()) {
            PersistentComponentVariables persistentTransformationVariables = persistentTransformation.getTransformationVariables();
            if (persistentTransformationVariables == null) {
                persistentTransformationVariables = new PersistentComponentVariables();
                persistentTransformation.setTransformationVariables(persistentTransformationVariables);
            }
            for (Variable localVar : transformTypeDescription.getVariables()) {
                PersistentComponentVariable persistentVariable = new PersistentComponentVariable();
                persistentVariable.setName(localVar.getName());
                persistentVariable.setType(localVar.getTypeRef().getText());
                persistentTransformationVariables.addChild((Element)persistentVariable);
            }
        }
    }

    private void visitComponentTransformationCodes(TransformTypeDescription transformTypeDescription, PersistentTransformation persistentTransformation) {
        SourceCode end;
        SourceCode begin = transformTypeDescription.getBeginCode();
        if (begin != null && !begin.isEmpty()) {
            PersistentBeginCode persistentBeginCode = persistentTransformation.getBeginCode();
            if (persistentBeginCode == null) {
                persistentBeginCode = new PersistentBeginCode();
                persistentTransformation.setBeginCode(persistentBeginCode);
            }
            persistentBeginCode.setLanguage(begin.getLanguage());
            persistentBeginCode.setCode(Str.escapeForScripts((String)String.valueOf(begin.getText())));
        }
        if ((end = transformTypeDescription.getEndCode()) != null && !end.isEmpty()) {
            PersistentEndCode persistentEndCode = persistentTransformation.getEndCode();
            if (persistentEndCode == null) {
                persistentEndCode = new PersistentEndCode();
                persistentTransformation.setEndCode(persistentEndCode);
            }
            persistentEndCode.setLanguage(end.getLanguage());
            persistentEndCode.setCode(Str.escapeForScripts((String)String.valueOf(end.getText())));
        }
    }

    private void visitComponentTransformationFieldMappings(PersistentTransformation persistentTransformation, TransformTypeDescription transformTypeDescription) {
        PersistentFieldMappings persistentFieldMappings = persistentTransformation.getFieldMappings();
        if (persistentFieldMappings == null) {
            persistentFieldMappings = new PersistentFieldMappings();
            persistentTransformation.setFieldMappings(persistentFieldMappings);
        }
        for (int j = 0; j < transformTypeDescription.getFieldMappingCount(); ++j) {
            TransformTypeDescription.FieldMapping fieldMapping = transformTypeDescription.getFieldMapping(j);
            SourceCode mappingCode = fieldMapping.getCode();
            PersistentFieldMapping persistentFieldMapping = new PersistentFieldMapping();
            persistentFieldMapping.setTargetField(fieldMapping.getTargetField());
            persistentFieldMapping.setIsExpression(fieldMapping.isExpression());
            persistentFieldMapping.setLanguage(mappingCode.getLanguage());
            String code = String.valueOf(fieldMapping.getCodeText());
            if (code != null && !code.equals("")) {
                persistentFieldMapping.setCode(code.trim());
            }
            persistentFieldMappings.addChild((Element)persistentFieldMapping);
        }
    }

    private void visitComponentTransformationSources(TransformTypeDescription transformTypeDescription, PersistentTransformation persistentTransformation) {
        if (transformTypeDescription.getSourceCount() > 0) {
            PersistentTransformationSources persistentTransformationSources = persistentTransformation.getTransformationSources();
            if (persistentTransformationSources == null) {
                persistentTransformationSources = new PersistentTransformationSources();
                persistentTransformation.setTransformationSources(persistentTransformationSources);
            }
            for (int j = 0; j < transformTypeDescription.getSourceCount(); ++j) {
                TypeDescription sourceType = transformTypeDescription.getSource(j);
                String sourceName = transformTypeDescription.getSourceName(j);
                PersistentTransformationSource persistentTransformationSource = new PersistentTransformationSource();
                persistentTransformationSource.setName(sourceName);
                persistentTransformationSource.setType(sourceType.getText());
                persistentTransformationSources.addChild((Element)persistentTransformationSource);
            }
        }
    }

    private void visitComponentMethods(ObjectTypeDescription otd) {
        PersistentMethods persistentOTDMethods = this.persistentOTD.getMethods();
        if (persistentOTDMethods == null) {
            persistentOTDMethods = new PersistentMethods();
            this.persistentOTD.setMethods(persistentOTDMethods);
        }
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            if (!otd.getMemberType(i).isMethod()) continue;
            this.visitComponentMethod(otd, otd.getMember(i), persistentOTDMethods);
        }
    }

    private void visitComponentMethod(ObjectTypeDescription otd, MethodTypeDescription mtd, PersistentMethods persistentOTDMethods) {
        TypeDescription cl = mtd.getParent();
        if (cl != null && cl.getName().equals("XObjectBase")) {
            return;
        }
        while (mtd != null) {
            long mods = mtd.getModifiers();
            if (!mtd.isSynthesized()) {
                PersistentMethod persistentMethod = new PersistentMethod();
                persistentMethod.setName(mtd.getName());
                persistentMethod.setReplacement(mtd.getReplacement());
                persistentMethod.setDescription(mtd.getDescription());
                persistentMethod.setFlags(Modifier.getText((long)mods));
                if (!otd.isBpmObject()) {
                    persistentMethod.setSignature(mtd.getSignature());
                }
                if (mtd.belongsToFuegoObject() || mtd.getCode() != null) {
                    persistentMethod.setLanguage(mtd.getCodeLanguage());
                }
                this.visitCompomentMethodRequires(mtd, persistentMethod);
                this.visitComponentMethodEnsures(mtd, persistentMethod);
                this.visitComponentTemplate(mtd, persistentMethod);
                this.visitComponentMethodArguments(mtd, persistentMethod);
                this.visitComponentMethodVariables(mtd, persistentMethod);
                this.visitComponentMethodOutputArgument(mtd, persistentMethod);
                this.visitComponentMethodExceptions(mtd, persistentMethod);
                this.visitComponentMethodCode(mtd, persistentMethod);
                this.visitComponentMethodProperties(mtd, persistentMethod);
                this.visitComponentMethodDocumentation(mtd, persistentMethod);
                persistentOTDMethods.addChild((Element)persistentMethod);
            }
            mtd = mtd.getNextMethod();
        }
    }

    private void visitComponentMethodDocumentation(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        PersistentDocumentations persistentDocs = persistentMethod.getDocumentations();
        if (persistentDocs == null) {
            persistentDocs = new PersistentDocumentations();
        }
        this.visitDocumentations(persistentDocs, (TypeDescription)mtd);
        if (!persistentDocs.isEmpty()) {
            persistentMethod.setDocumentations(persistentDocs);
        }
    }

    private void visitComponentMethodCode(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        char[] code = mtd.getCodeText();
        if (code != null && code.length > 0) {
            persistentMethod.setText(Str.escapeForScripts((String)String.valueOf(code).trim()));
        }
    }

    private void visitComponentTemplate(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        if (mtd.getTemplate() != null && !mtd.getTemplate().equals("")) {
            persistentMethod.setMethodTemplate(Str.escapeForScripts((String)mtd.getTemplate()));
        }
    }

    private void visitComponentMethodProperties(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        PersistentProperties methodProperties = persistentMethod.getProperties();
        if (methodProperties == null) {
            methodProperties = new PersistentProperties();
        }
        this.visitProperties(mtd.getProperties(), methodProperties);
        if (!methodProperties.isEmpty()) {
            persistentMethod.setProperties(methodProperties);
        }
    }

    private void visitComponentMethodExceptions(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        PersistentComponentExceptions persistentExceptions = persistentMethod.getComponentExceptions();
        if (persistentExceptions == null) {
            persistentExceptions = new PersistentComponentExceptions();
        }
        int length = mtd.getExceptionCount();
        for (int i = 0; i < length; ++i) {
            TypeDescription exception = mtd.getException(i);
            PersistentComponentException persistentException = new PersistentComponentException();
            persistentException.setType(exception.getText());
            persistentExceptions.addException(persistentException);
        }
        if (!persistentExceptions.isEmpty()) {
            persistentMethod.setComponentExceptions(persistentExceptions);
        }
    }

    private void visitComponentMethodVariables(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        PersistentComponentVariables methodVariables = persistentMethod.getMethodVariables();
        if (methodVariables == null) {
            methodVariables = new PersistentComponentVariables();
        }
        this.visitVariables(methodVariables, mtd.getVariables());
        if (!methodVariables.isEmpty()) {
            persistentMethod.setMethodVariables(methodVariables);
        }
    }

    private void visitComponentMethodOutputArgument(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        TypeDescription returnType = mtd.getResultType();
        long modifiers = mtd.getResultArgument().getModifiers();
        if (returnType.getKind() != 0) {
            PersistentMethodArguments persistentMethodArguments = persistentMethod.getMethodArguments();
            if (persistentMethodArguments == null) {
                persistentMethodArguments = new PersistentMethodArguments();
                persistentMethod.setMethodArguments(persistentMethodArguments);
            }
            PersistentOutputArgument outputArgument = new PersistentOutputArgument();
            outputArgument.setName(mtd.getResultArgument().getName());
            outputArgument.setDescription(mtd.getResultArgument().getDescription());
            outputArgument.setFlags(Modifier.getText((long)modifiers));
            outputArgument.setPrimitive(returnType.isPrimitive());
            String type = returnType.getText();
            if (type == null) {
                Log.logWarning((Msg)LibMsg.TYPE_IS_NULL((TypeDescription)returnType));
            }
            outputArgument.setType(type);
            if (returnType.getJavaType() == null) {
                outputArgument.setJavaType(mtd.getResultArgument().getJavaType());
            } else if (!returnType.getJavaType().equals(mtd.getResultArgument().getJavaType()) || mtd.getResultArgument().getJavaType() != null && mtd.getResultArgument().getJavaType().indexOf("[") != -1) {
                outputArgument.setJavaType(mtd.getResultArgument().getJavaType());
            }
            persistentMethodArguments.addArgument(outputArgument);
        }
    }

    private void visitComponentMethodArguments(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        if (mtd.getArgumentCount() > 0) {
            PersistentMethodArguments persistentMethodArguments = persistentMethod.getMethodArguments();
            if (persistentMethodArguments == null) {
                persistentMethodArguments = new PersistentMethodArguments();
                persistentMethod.setMethodArguments(persistentMethodArguments);
            }
            for (int j = 0; j < mtd.getArgumentCount(); ++j) {
                Argument arg = mtd.getArgument(j);
                TypeDescription argType = arg.getType();
                PersistentInputArgument inputArgument = new PersistentInputArgument();
                inputArgument.setName(arg.getName());
                inputArgument.setDescription(arg.getDescription());
                inputArgument.setFlags(Modifier.getText((long)arg.getModifiers()));
                inputArgument.setPrimitive(argType.isPrimitive());
                inputArgument.setType(argType.getText());
                inputArgument.setDefaultValue(arg.getDefaultValue());
                this.visitArgumentJavaType(arg, inputArgument);
                if (arg.hasProperties()) {
                    this.visitMethodArgumentProperties(inputArgument, arg);
                }
                persistentMethodArguments.addArgument(inputArgument);
            }
        }
    }

    private void visitMethodArgumentProperties(PersistentArgument persistentArgument, Argument arg) {
        PersistentProperties persitentMethodArgumentProperties = persistentArgument.getProperties();
        if (persitentMethodArgumentProperties == null) {
            persitentMethodArgumentProperties = new PersistentProperties();
            persistentArgument.setProperties(persitentMethodArgumentProperties);
        }
        this.visitProperties(arg.getProperties(), persitentMethodArgumentProperties);
    }

    private void visitArgumentJavaType(Argument arg, PersistentInputArgument persistentArgument) {
        String standardType = arg.getType().getJavaType();
        String resultJavaType = arg.getJavaType();
        if (resultJavaType != null && (standardType != null && this.isGroupArray(standardType) || arg.isExternal())) {
            persistentArgument.setJavaType(resultJavaType);
        } else if (!Any.equals((Object)standardType, (Object)resultJavaType) || resultJavaType != null && resultJavaType.indexOf("[") != -1 && !"byte[]".equals(resultJavaType)) {
            persistentArgument.setJavaType(resultJavaType);
        }
    }

    private void visitComponentMethodEnsures(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        Validation[] ensureCode = mtd.getEnsureCode();
        if (ensureCode != null) {
            PersistentEnsures ensures = persistentMethod.getEnsures();
            if (ensures == null) {
                ensures = new PersistentEnsures();
            }
            this.visitEnsures(ensureCode, ensures);
            if (!ensures.isEmpty()) {
                persistentMethod.setEnsures(ensures);
            }
        }
    }

    private void visitCompomentMethodRequires(MethodTypeDescription mtd, PersistentMethod persistentMethod) {
        Validation[] requireCode = mtd.getRequireCode();
        if (requireCode != null) {
            PersistentRequires requires = persistentMethod.getRequires();
            if (requires == null) {
                requires = new PersistentRequires();
            }
            this.visitRequires(requireCode, requires);
            if (!requires.isEmpty()) {
                persistentMethod.setRequires(requires);
            }
        }
    }

    private void visitComponentAttributes(ObjectTypeDescription otd) {
        PersistentAttributes persistentOTDAttributes = this.persistentOTD.getAttributesValue();
        if (persistentOTDAttributes == null) {
            persistentOTDAttributes = new PersistentAttributes();
            this.persistentOTD.setAttributesValue(persistentOTDAttributes);
        }
        for (MethodTypeDescription member : otd.getAttributes()) {
            this.visitComponentAttribute(member, otd, persistentOTDAttributes, false);
        }
    }

    private void visitComponentAttribute(MethodTypeDescription mtd, ObjectTypeDescription otd, PersistentAttributes persistentAttributes, boolean group) {
        PersistentAbstractAttribute abstractAttribute;
        if (mtd.isSynthesized()) {
            return;
        }
        TypeDescription type = mtd.getResultType();
        TypeDescription elementType = type.getElementType();
        TypeDescription indexType = type.getIndexType();
        if (group && type instanceof ArrayTypeDescription) {
            type = type.getElementType();
        }
        String modifiersText = Modifier.getText((long)mtd.getModifiers());
        AttributeTypeDescription attribute = mtd.asAttribute();
        if (type.getKind() == 12) {
            PersistentArrayAttribute arrayAttribute = new PersistentArrayAttribute();
            arrayAttribute.setType(elementType.getText());
            abstractAttribute = arrayAttribute;
        } else if (type.getKind() == 13) {
            PersistentMapAttribute mapAttribute = new PersistentMapAttribute();
            mapAttribute.setType(elementType.getText());
            mapAttribute.setIndexType(indexType.getText());
            mapAttribute.setOrdered(type.isOrdered());
            abstractAttribute = mapAttribute;
        } else if (type.getKind() == 16) {
            PersistentIteratorAttribute iteratorAttribute = new PersistentIteratorAttribute();
            iteratorAttribute.setType(elementType.getText());
            abstractAttribute = iteratorAttribute;
        } else if (type.isPredefined()) {
            PersistentAbstractPredefinedAttribute predefinedAttribute;
            switch (type.getKind()) {
                case 1: {
                    predefinedAttribute = new PersistentBoolAttribute();
                    break;
                }
                case 2: {
                    predefinedAttribute = new PersistentIntegerAttribute();
                    break;
                }
                case 3: {
                    predefinedAttribute = new PersistentDecimalAttribute();
                    break;
                }
                case 4: {
                    predefinedAttribute = new PersistentRealAttribute();
                    break;
                }
                case 5: {
                    predefinedAttribute = new PersistentStringAttribute();
                    break;
                }
                case 6: {
                    predefinedAttribute = new PersistentTimeAttribute();
                    break;
                }
                case 7: {
                    predefinedAttribute = new PersistentIntervalAttribute();
                    break;
                }
                case 8: {
                    predefinedAttribute = new PersistentBinaryAttribute();
                    break;
                }
                case 9: {
                    predefinedAttribute = new PersistentNullAttribute();
                    break;
                }
                case 10: {
                    predefinedAttribute = new PersistentAnyAttribute();
                    break;
                }
                default: {
                    predefinedAttribute = new PersistentFirstPredefinedAttribute();
                }
            }
            if (type.getLength() != -1) {
                predefinedAttribute.setLength(Long.valueOf(type.getLength()));
            }
            if (type.getScale() != -1) {
                predefinedAttribute.setScale(Long.valueOf(type.getScale()));
            }
            predefinedAttribute.setDefaultValue(attribute.getDefaultValue());
            predefinedAttribute.setValidValues(this.getDelimited((List<String>)attribute.getValidValues(), "|"));
            if (attribute.getPrecision() != -1) {
                predefinedAttribute.setPrecision(Long.valueOf(attribute.getPrecision()));
            }
            abstractAttribute = predefinedAttribute;
        } else {
            PersistentObjectAttribute objectAttribute = new PersistentObjectAttribute();
            objectAttribute.setType(type.getText());
            if (type.getLength() != -1) {
                objectAttribute.setLength(Long.valueOf(type.getLength()));
            }
            if (type.getScale() != -1) {
                objectAttribute.setScale(Long.valueOf(type.getScale()));
            }
            objectAttribute.setDefaultValue(attribute.getDefaultValue());
            objectAttribute.setValidValues(this.getDelimited((List<String>)attribute.getValidValues(), "|"));
            if (attribute.getPrecision() != -1) {
                objectAttribute.setPrecision(Long.valueOf(attribute.getPrecision()));
            }
            abstractAttribute = objectAttribute;
        }
        abstractAttribute.setName(mtd.getName());
        abstractAttribute.setReplacement(mtd.getReplacement());
        abstractAttribute.setDescription(mtd.getDescription());
        abstractAttribute.setTemplate(mtd.getTemplate());
        abstractAttribute.setFlags(modifiersText);
        abstractAttribute.setPrimitive(type.isPrimitive());
        int position = attribute.getPosition();
        if (position != -1) {
            abstractAttribute.setPositionValue(Long.valueOf(position));
        }
        Argument result = mtd.getResultArgument();
        this.visitComponentJavaType(result, abstractAttribute);
        if (!otd.isBpmObject()) {
            abstractAttribute.setWriteSignature(attribute.getWriteSignature());
            abstractAttribute.setReadSignature(mtd.getSignature());
        }
        this.visitComponentAttributeRequires(mtd, abstractAttribute);
        this.visitComponentAttributeEnsures(mtd, abstractAttribute);
        this.visitComponentAttributeIntegrityChecks(mtd, abstractAttribute);
        this.visitComponentAttributeReadCode(mtd.getCode(), attribute, abstractAttribute);
        this.visitComponentAttributeWriteCode(mtd.asAttribute().getWriteCode(), attribute, abstractAttribute);
        this.visitComponentAttributeProperties(mtd, abstractAttribute);
        this.visitComponentAtributeDocumentation(mtd, abstractAttribute);
        persistentAttributes.addAttribute(abstractAttribute);
    }

    private void visitComponentAtributeDocumentation(MethodTypeDescription mtd, PersistentAbstractAttribute abstractAttribute) {
        PersistentDocumentations persistentDocs = abstractAttribute.getDocumentations();
        if (persistentDocs == null) {
            persistentDocs = new PersistentDocumentations();
        }
        this.visitDocumentations(persistentDocs, (TypeDescription)mtd);
        if (!persistentDocs.isEmpty()) {
            abstractAttribute.setDocumentations(persistentDocs);
        }
    }

    private void visitComponentAttributeWriteCode(SourceCode writeCode, AttributeTypeDescription attribute, PersistentAbstractAttribute abstractAttribute) {
        if (writeCode != null) {
            PersistentWriteCode persistentWriteCode = abstractAttribute.getWriteCode();
            if (persistentWriteCode == null) {
                persistentWriteCode = new PersistentWriteCode();
                abstractAttribute.setWriteCode(persistentWriteCode);
            }
            String text = new String(writeCode.getText());
            persistentWriteCode.setLanguage(writeCode.getLanguage());
            PersistentComponentVariables codeVariables = persistentWriteCode.getSourceCodeVariables();
            if (codeVariables == null) {
                codeVariables = new PersistentComponentVariables();
                persistentWriteCode.setSourceCodeVariables(codeVariables);
            }
            this.visitVariables(codeVariables, attribute.getWriteVariables());
            persistentWriteCode.setCode(text.trim());
        }
    }

    private void visitComponentAttributeReadCode(SourceCode readCode, AttributeTypeDescription attribute, PersistentAbstractAttribute abstractAttribute) {
        if (readCode != null) {
            PersistentReadCode persistentReadCode = abstractAttribute.getReadCode();
            if (persistentReadCode == null) {
                persistentReadCode = new PersistentReadCode();
                abstractAttribute.setReadCode(persistentReadCode);
            }
            String text = new String(readCode.getText());
            persistentReadCode.setLanguage(readCode.getLanguage());
            PersistentComponentVariables codeVariables = persistentReadCode.getSourceCodeVariables();
            if (codeVariables == null) {
                codeVariables = new PersistentComponentVariables();
                persistentReadCode.setSourceCodeVariables(codeVariables);
            }
            this.visitVariables(codeVariables, attribute.getVariables());
            persistentReadCode.setCode(text.trim());
        }
    }

    private void visitVariables(PersistentComponentVariables persistentVariables, Collection<Variable> variables) {
        for (Variable variable : variables) {
            TypeRef argType = variable.getTypeRef();
            PersistentComponentVariable persistentVariable = new PersistentComponentVariable();
            persistentVariable.setName(variable.getName());
            persistentVariable.setType(argType.getText());
            persistentVariables.addVariable(persistentVariable);
        }
    }

    private void visitComponentAttributeProperties(MethodTypeDescription mtd, PersistentAbstractAttribute abstractAttribute) {
        PersistentProperties persistentProperties = abstractAttribute.getProperties();
        if (persistentProperties == null) {
            persistentProperties = new PersistentProperties();
        }
        this.visitProperties(mtd.getProperties(), persistentProperties);
        if (!persistentProperties.isEmpty()) {
            abstractAttribute.setProperties(persistentProperties);
        }
    }

    private void visitComponentAttributeIntegrityChecks(MethodTypeDescription mtd, PersistentAbstractAttribute abstractAttribute) {
        Validation[] integrityCheckCode = mtd.getCheckCode();
        if (integrityCheckCode != null) {
            PersistentIntegrityChecks integrityChecks = abstractAttribute.getIntegrityChecks();
            if (integrityChecks == null) {
                integrityChecks = new PersistentIntegrityChecks();
            }
            for (Validation sourceCode : integrityCheckCode) {
                String checkText = new String(sourceCode.getText());
                if (checkText.equals("")) continue;
                PersistentIntegrityCheck persistentIntegrityCheck = new PersistentIntegrityCheck();
                persistentIntegrityCheck.setLanguage(sourceCode.getLanguage());
                persistentIntegrityCheck.setMessage(sourceCode.getMessage());
                persistentIntegrityCheck.setChars(checkText);
                integrityChecks.addChild((Element)persistentIntegrityCheck);
            }
            if (!integrityChecks.isEmpty()) {
                abstractAttribute.setIntegrityChecks(integrityChecks);
            }
        }
    }

    private void visitComponentAttributeEnsures(MethodTypeDescription mtd, PersistentAbstractAttribute abstractAttribute) {
        Validation[] ensureCode = mtd.getEnsureCode();
        if (ensureCode != null) {
            PersistentEnsures ensures = abstractAttribute.getEnsures();
            if (ensures == null) {
                ensures = new PersistentEnsures();
            }
            this.visitEnsures(ensureCode, ensures);
            if (!ensures.isEmpty()) {
                abstractAttribute.setEnsures(ensures);
            }
        }
    }

    private void visitEnsures(Validation[] ensureCode, PersistentEnsures ensures) {
        for (Validation validation : ensureCode) {
            PersistentEnsure persistentEnsure = new PersistentEnsure();
            persistentEnsure.setLanguage(validation.getLanguage());
            persistentEnsure.setMessage(validation.getMessage());
            persistentEnsure.setChars(new String(validation.getText()));
            ensures.addChild((Element)persistentEnsure);
        }
    }

    private void visitComponentAttributeRequires(MethodTypeDescription mtd, PersistentAbstractAttribute abstractAttribute) {
        Validation[] requireCode = mtd.getRequireCode();
        if (requireCode != null) {
            PersistentRequires requires = abstractAttribute.getRequires();
            if (requires == null) {
                requires = new PersistentRequires();
            }
            this.visitRequires(requireCode, requires);
            if (!requires.isEmpty()) {
                abstractAttribute.setRequires(requires);
            }
        }
    }

    private void visitRequires(Validation[] requireCode, PersistentRequires requires) {
        for (Validation validation : requireCode) {
            String message = validation.getMessage();
            char[] text = validation.getText();
            if (text == null && message == null) continue;
            PersistentRequire persistentRequire = new PersistentRequire();
            persistentRequire.setLanguage(validation.getLanguage());
            persistentRequire.setMessage(message);
            persistentRequire.setChars(text != null ? new String(text) : "");
            requires.addChild((Element)persistentRequire);
        }
    }

    private void visitComponentJavaType(Argument result, PersistentAbstractAttribute abstractAttribute) {
        String standardType = result.getType().getJavaType();
        String resultJavaType = result.getJavaType();
        if (resultJavaType != null && (standardType != null && this.isGroupArray(standardType) || result.isExternal())) {
            abstractAttribute.setJavaType(resultJavaType);
        } else if (!Any.equals((Object)standardType, (Object)resultJavaType) || resultJavaType != null && resultJavaType.indexOf("[") != -1 && !"byte[]".equals(resultJavaType)) {
            abstractAttribute.setJavaType(resultJavaType);
        }
    }

    private boolean isGroupArray(String standardType) {
        return standardType.equals("oracle.bpm.util.LegacyGroupArray") || standardType.equals("oracle.bpm.xobject.GroupArray");
    }

    private String getDelimited(List<String> elements, String delimiter) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        Iterator<String> it = elements.iterator();
        while (it.hasNext()) {
            text.append(String.valueOf(it.next()));
            if (!it.hasNext()) continue;
            text.append(delimiter);
        }
        return text.toString();
    }

    private void visitComponentProperties(ObjectTypeDescription otd) {
        PersistentProperties persitentOTDProperties = this.persistentOTD.getObjectProperties();
        if (persitentOTDProperties == null) {
            persitentOTDProperties = new PersistentProperties();
            this.persistentOTD.setObjectProperties(persitentOTDProperties);
        }
        this.visitProperties(otd.getProperties(), persitentOTDProperties);
    }

    private void visitProperties(Map<String, String> properties, PersistentProperties persitentOTDProperties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            persitentOTDProperties.addStringProperty(entry.getKey(), String.valueOf(value));
        }
    }

    private void visitComponentHeader(ObjectTypeDescription otd) {
        PersistentFeatureSet otdFeatureSet = this.persistentOTD.getFeatureSet();
        if (otdFeatureSet == null) {
            otdFeatureSet = new PersistentFeatureSet();
            this.persistentOTD.setFeatureSet(otdFeatureSet);
        }
        otdFeatureSet.addStringFeature("name", otd.getName());
        otdFeatureSet.addStringFeature("description", otd.getDescription());
        otdFeatureSet.addStringFeature("versionID", otd.getVersionID());
        otdFeatureSet.addStringFeature("flags", Modifier.getText((long)otd.getModifiers()));
        if (!otd.isBpmObject()) {
            otdFeatureSet.addStringFeature("signature", otd.getSignature());
        }
        otdFeatureSet.addBooleanFeature("remote", otd.isRemote());
        otdFeatureSet.addBooleanFeature("dynamic", Modifier.isInvokeable((long)otd.getModifiers()));
        otdFeatureSet.addStringFeature("type", otd.getComponentType());
        TypeDescription elementType = otd.getElementType();
        if (elementType != null) {
            otdFeatureSet.addStringFeature("elementType", elementType.getText());
        }
        this.visitComponentInherits(otdFeatureSet, otd);
    }

    private void visitComponentInherits(PersistentFeatureSet otdFeatureSet, ObjectTypeDescription otd) {
        PersistentFeatureSet inheritsFeatureSet = otdFeatureSet.getChildFeatureSet("inherits");
        if (inheritsFeatureSet == null) {
            inheritsFeatureSet = new PersistentFeatureSet("inherits");
            otdFeatureSet.addChildFeatureSet(inheritsFeatureSet);
        }
        for (SuperType superType : otd.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (type.isNone() && !(type instanceof DynamicRef)) continue;
            PersistentFeatureSet inheritFeatureSet = new PersistentFeatureSet("inherit");
            inheritFeatureSet.addStringFeature("class", type.getText());
            inheritFeatureSet.addStringFeature("flags", Modifier.getText((long)superType.getModifiers()));
            inheritsFeatureSet.addChildFeatureSet(inheritFeatureSet);
        }
    }
}

