/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ModelFormatMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;

public interface ModelFormat {
    public SchemaType getSchema();

    public Object parse(InputStream var1, Project var2, Process var3, boolean var4) throws ProjectException;

    public void writeXml(Process var1, Writer var2) throws IOException, ProjectException;

    public static class Extension {
        private static Map<SchemaType, ModelFormat> formats = new HashMap<SchemaType, ModelFormat>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ModelFormat get(SchemaType schema) {
            Class<Extension> clazz = Extension.class;
            synchronized (Extension.class) {
                ModelFormat result = formats.get(schema);
                if (result == null) {
                    List<ModelFormat> all = Extension.getAll();
                    for (ModelFormat format : all) {
                        if (formats.containsKey(format.getSchema())) continue;
                        formats.put(format.getSchema(), format);
                    }
                    result = formats.get(schema);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public static List<ModelFormat> getAll() {
            ArrayList<ModelFormat> result = new ArrayList<ModelFormat>();
            ExtensionService extensionService = Platform.getExtensionService();
            List extensions = extensionService.getExtensionsByPoint(ModelFormatMetadata.class);
            for (oracle.bpm.extension.Extension extension : extensions) {
                try {
                    ModelFormat format = (ModelFormat)extension.instantiateAs(ModelFormat.class);
                    result.add(format);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }
}

