/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.bpmn.jaxb.ObjectFactory;
import oracle.bpm.project.io.serializers.model.ModelFormat;
import oracle.bpm.project.io.serializers.model.ModelParseException;
import oracle.bpm.project.io.serializers.model.PersistenceType;
import oracle.bpm.project.io.serializers.model.ProcessVisitor;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPackageType;
import oracle.bpm.project.io.serializers.model.bpmn.BPMN20Loader;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ImporterException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.FileRevisionFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.activities.SharePredefinedVariablesFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.xml.JaxbHelper;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultModelFormat
implements ModelFormat {
    public static final String BPMNJaxbPackage = "fuego.project.io.bpmn.jaxb:fuego.project.io.bpmn.jaxb.extensions";
    @NonNls
    private static final String XPDL_VERSION_STRING = "XPDLVersion";
    @NonNls
    private static final String XPDL_PACKAGE_STRING = "Package";
    @NonNls
    private static String BPMN20_NS = "http://www.omg.org/bpmn20";
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class, oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory.class});
    private static final String VERSION = "version";
    private static final String REVISION = "revision";

    public static void load(Process process, InputStream stream) throws ProjectException {
        DefaultModelFormat.loadInternal(process, stream, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(Process process, File sourceFile) throws ProjectException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(sourceFile);
        try {
            if (sourceFile.getName().toLowerCase().endsWith(".xpdl")) {
                DefaultModelFormat.loadXPDLCompliantModel(process, fileInputStream);
            } else {
                DefaultModelFormat.load(process, fileInputStream);
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException(e);
                catch (ParserException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
    }

    public static Process createFrom(@NotNull Project project, @NotNull File file) throws ProjectException, FileNotFoundException {
        Process process = project.createModel("");
        DefaultModelFormat.load(process, file);
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLanguageNameSpace(String xpdl) {
        String string;
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(xpdl);
            string = DefaultModelFormat.getProperLanguageNameSpace(stringReader);
        }
        catch (IOException e) {
            try {
                Log.logWarning((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{stringReader});
                throw throwable;
            }
            StreamUtils.close((Closeable[])new Closeable[]{stringReader});
            return null;
        }
        StreamUtils.close((Closeable[])new Closeable[]{stringReader});
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLanguageNameSpace(File sourceFile) {
        String string;
        FileReader stringReader = null;
        try {
            stringReader = new FileReader(sourceFile);
            string = DefaultModelFormat.getProperLanguageNameSpace(stringReader);
        }
        catch (IOException e) {
            try {
                Log.logWarning((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{stringReader});
                throw throwable;
            }
            StreamUtils.close((Closeable[])new Closeable[]{stringReader});
            return null;
        }
        StreamUtils.close((Closeable[])new Closeable[]{stringReader});
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLanguageNameSpace(VFile sourceFile) {
        String string;
        InputStreamReader stringReader = null;
        try {
            stringReader = new InputStreamReader((InputStream)new VFileInputStream(sourceFile));
            string = DefaultModelFormat.getProperLanguageNameSpace(stringReader);
        }
        catch (IOException e) {
            try {
                Log.logWarning((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{stringReader});
                throw throwable;
            }
            StreamUtils.close((Closeable[])new Closeable[]{stringReader});
            return null;
        }
        StreamUtils.close((Closeable[])new Closeable[]{stringReader});
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isXPDL(File sourceFile, ProjectObject project) throws ImporterException {
        boolean bl;
        FileReader stringReader = null;
        try {
            stringReader = new FileReader(sourceFile);
            bl = DefaultModelFormat.getLanguageNameSpace(stringReader, project) != PersistenceType.XPDL_10;
        }
        catch (IOException e) {
            try {
                Log.logWarning((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{stringReader});
                throw throwable;
            }
            StreamUtils.close((Closeable[])new Closeable[]{stringReader});
            return false;
        }
        StreamUtils.close((Closeable[])new Closeable[]{stringReader});
        return bl;
    }

    @Override
    public void writeXml(Process process, Writer writer) throws IOException, ProjectException {
        this.writeBpmn20(process, writer);
    }

    @Override
    public Object parse(InputStream is, Project project, Process processContent, boolean onlyInfo) throws ProjectException {
        DefaultModelFormat.load(processContent, is);
        return processContent;
    }

    private static String getProperLanguageNameSpace(Reader reader) throws IOException {
        PersistenceType languageNameSpace = DefaultModelFormat.getLanguageNameSpace(reader);
        if (PersistenceType.BPMN20.equals((Object)languageNameSpace)) {
            return BPMN20_NS;
        }
        return PersistenceType.XPDL_20.equals((Object)languageNameSpace) ? PersistentPackageType.ALBPM_XPDL20_NS : null;
    }

    private static PersistenceType getLanguageNameSpace(Reader reader) throws IOException {
        try {
            return DefaultModelFormat.getLanguageNameSpace(reader, null);
        }
        catch (ImporterException e) {
            Log.logWarning((Msg)e.getMsg());
            return null;
        }
    }

    @NotNull
    private static Map<String, String> getFileRevision(Reader reader) throws IOException, ImporterException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        HashMap<String, String> values = new HashMap<String, String>();
        block0: for (int i = 0; i < 5 && (line = bufferedReader.readLine()) != null; ++i) {
            StringTokenizer st = new StringTokenizer(line, "<>", false);
            while (st.hasMoreTokens()) {
                String tag = st.nextToken();
                if (tag.indexOf("?xml") != -1 || tag.indexOf("!--") != -1) continue;
                int versionPos = tag.indexOf("?oracleBPM version");
                int revisionPos = tag.indexOf("fileRevision");
                if (versionPos == -1 || revisionPos == -1) continue;
                values.put(VERSION, DefaultModelFormat.getPropertyValue(tag, VERSION));
                values.put(REVISION, DefaultModelFormat.getPropertyValue(tag, "fileRevision"));
                continue block0;
            }
        }
        return values;
    }

    private static String getPropertyValue(String baseString, String key) {
        int secondQuote;
        int firstQuote;
        int keyPos = baseString.indexOf(key);
        int quote = 34;
        String propertyValue = null;
        if (keyPos != -1 && (firstQuote = baseString.indexOf(34, keyPos + key.length())) != -1 && firstQuote + 1 < baseString.length() && (secondQuote = baseString.indexOf(34, firstQuote + 1)) != -1) {
            propertyValue = baseString.substring(firstQuote + 1, secondQuote).trim();
        }
        return propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistenceType getLanguageNameSpace(Reader reader, ProjectObject projectObject) throws IOException, ImporterException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            for (int i = 0; i < 5 && (line = bufferedReader.readLine()) != null; ++i) {
                StringTokenizer st = new StringTokenizer(line, "<", false);
                while (st.hasMoreTokens()) {
                    String tag = st.nextToken();
                    if (tag.indexOf("?xml") != -1 || tag.indexOf("?fuego") != -1 || tag.indexOf("!--") != -1) continue;
                    if (tag.indexOf(BPMN20_NS) != -1) {
                        PersistenceType persistenceType = PersistenceType.BPMN20;
                        return persistenceType;
                    }
                    if (tag.indexOf(XPDL_PACKAGE_STRING) != -1) {
                        PersistenceType persistenceType = PersistenceType.XPDL_20;
                        return persistenceType;
                    }
                    if (tag.indexOf("process") == -1) continue;
                    PersistenceType persistenceType = PersistenceType.FUEGO57;
                    return persistenceType;
                }
            }
        }
        finally {
            bufferedReader.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadXPDLCompliantModel(Process mutableModel, InputStream stream) throws ProjectException, ParserException, UnsupportedEncodingException {
        mutableModel.init();
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            inputStreamReader = new InputStreamReader(stream, Literals.DEFAULT_ENCODING);
            reader = new BufferedReader(inputStreamReader);
            PersistentPackageType.buildFrom(reader, mutableModel);
        }
        catch (Throwable throwable) {
            StreamUtils.close((Closeable[])new Closeable[]{reader});
            StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
            throw throwable;
        }
        StreamUtils.close((Closeable[])new Closeable[]{reader});
        StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
    }

    private static void loadBPMN20CompliantModel(Process process, InputStream inputStream) throws ProjectException, ParserException, UnsupportedEncodingException {
        process.init();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 16384);
        BufferedReader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(bufferedInputStream);
            reader = new BufferedReader(inputStreamReader);
            bufferedInputStream.mark(4096);
            Map<String, String> fileRevision = DefaultModelFormat.getFileRevision(reader);
            bufferedInputStream.reset();
            FileRevisionFeature revisionFeature = process.getFeature(FileRevisionFeature.class);
            String version = fileRevision.get(VERSION);
            revisionFeature.setVersion(version == null ? Id.getAbsoluteVersion() : version);
            String revision = fileRevision.get(REVISION);
            revisionFeature.setRevision(revision == null ? Integer.valueOf("20090820") : Integer.valueOf(revision));
            BPMN20Loader bpmn20Loader = new BPMN20Loader(process, bufferedInputStream);
            bpmn20Loader.load();
        }
        catch (IOException e) {
            try {
                throw ProjectException.wrap(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{reader});
                StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
                StreamUtils.close((Closeable[])new Closeable[]{bufferedInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{reader});
        StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
        StreamUtils.close((Closeable[])new Closeable[]{bufferedInputStream});
    }

    private static void loadInternal(Process model, InputStream stream, boolean infoOnly) throws ProjectException {
        try {
            DefaultModelFormat.loadBPMN20CompliantModel(model, stream);
        }
        catch (ParserException e) {
            throw ModelParseException.wrap((ProjectObject)model, e);
        }
        catch (UnsupportedEncodingException e) {
            throw ProjectException.wrap((ProjectObject)model, e);
        }
    }

    private static void load57Model(Process process, InputStream stream, boolean infoOnly) throws ProjectException {
        process.init();
        SharePredefinedVariablesFeature predefinedVariablesFeature = process.getFeature(SharePredefinedVariablesFeature.class);
        if (predefinedVariablesFeature != null) {
            predefinedVariablesFeature.setValue(false);
        }
    }

    private void writeBpmn20(Process process, Writer writer) throws ProjectException {
        ProcessVisitor processVisitor = new ProcessVisitor();
        process.visit(processVisitor);
        try {
            JAXBContext jaxbContext = JAXB_CONTEXT;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.omg.org/bpmn20");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            writer.write("<?oracleBPM version=\"" + Id.getAbsoluteVersion() + "\" fileRevision=\"" + "20100225" + "\"?>\n");
            marshaller.marshal(processVisitor.getDefinitions(), writer);
        }
        catch (Exception e) {
            try {
                throw ProjectException.wrap((ProjectObject)process, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{writer});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{writer});
    }
}

