/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.layout;

import java.io.IOException;
import java.util.Collection;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.presentation.layouts.Layout;
import oracle.bpm.xml.XmlWriter;

public class XmlLayoutSerializer
extends BaseXmlSerializer {
    public static final String ATTR_XML = "xml";
    public static final String ELEM_LAYOUT = "layout";

    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        Layout layout = (Layout)object;
        xmlWriter.startElement(ELEM_LAYOUT);
        xmlWriter.printValuedElement("id", layout.getId());
        xmlWriter.printValuedElement("name", layout.getName());
        this.writeRoleAssignments(xmlWriter, layout);
        xmlWriter.printCDATAElement(ATTR_XML, layout.getXml());
        xmlWriter.endElement();
    }

    private void writeRoleAssignments(XmlWriter xmlWriter, Layout layout) throws IOException {
        Collection<RoleAssignment> roleAssignments = layout.getRoleAssignments();
        if (!roleAssignments.isEmpty()) {
            xmlWriter.startElement("rolesAssignment");
            for (RoleAssignment roleAssignment : roleAssignments) {
                xmlWriter.startElement("roleAssignment");
                xmlWriter.printValuedElement("roleId", roleAssignment.getRoleId());
                xmlWriter.printValuedElement("parametricValue", roleAssignment.getParametricValue());
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
    }
}

