/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.dashboard.xml;

import java.math.BigDecimal;
import oracle.bpm.data.BusinessVariableData;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.xml.sax.Attributes;

class RangeFactory
extends AbstractObjectCreationFactory {
    RangeFactory() {
    }

    public Object createObject(Attributes attributes) throws Exception {
        BigDecimal finish;
        BigDecimal start;
        String name = attributes.getValue("name");
        String startStr = attributes.getValue("start");
        String finishStr = attributes.getValue("finish");
        if (startStr == null || finishStr == null) {
            throw new Exception("Mandatories attributes start or finish not present on range tag.");
        }
        try {
            start = BigDecimal.valueOf(Long.parseLong(startStr));
            finish = BigDecimal.valueOf(Long.parseLong(finishStr));
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid value for start or finish attribute on range tag.", e);
        }
        return BusinessVariableData.Range.create((String)name, (BigDecimal)start, (BigDecimal)finish);
    }
}

