/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.dashboard.xml;

import oracle.bpm.dashboard.model.drilldown.DrillDownType;
import oracle.bpm.project.dashboard.drilldown.InstancesViewDrillDownAdapter;
import oracle.bpm.project.dashboard.drilldown.ViewDrillDownAdapter;
import oracle.bpm.project.dashboard.drilldown.WidgetDrillDownAdapter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.xml.sax.Attributes;

public class DrillDownCreationFactory
extends AbstractObjectCreationFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createObject(Attributes attributes) throws Exception {
        InstancesViewDrillDownAdapter result = null;
        if (attributes == null) return result;
        String currentAttributeName = "type";
        String value = attributes.getValue(currentAttributeName);
        if (this.validString(value)) {
            DrillDownType type = DrillDownType.valueOf((String)value);
            currentAttributeName = "projectId";
            String projectId = attributes.getValue(currentAttributeName);
            ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
            Project project = repository != null && this.validString(projectId) ? repository.getProject(projectId) : null;
            switch (type) {
                case INSTANCES_VIEW_DRILL_DOWN: {
                    return new InstancesViewDrillDownAdapter();
                }
                case VIEW_DRILL_DOWN: {
                    if (this.validString(projectId)) {
                        if (project == null) return result;
                        currentAttributeName = "view";
                        String viewId = attributes.getValue(currentAttributeName);
                        if (this.validString(viewId)) {
                            return new ViewDrillDownAdapter(project, viewId);
                        }
                        this.throwException(currentAttributeName);
                        return result;
                    }
                    this.throwException(currentAttributeName);
                    return result;
                }
                case WIDGET_DRILL_DOWN: {
                    currentAttributeName = "widgetName";
                    String widgetName = attributes.getValue(currentAttributeName);
                    if (this.validString(widgetName)) {
                        currentAttributeName = "predefined";
                        String predefined = attributes.getValue(currentAttributeName);
                        if (this.validString(predefined)) {
                            if (this.validString(projectId)) {
                                if (project == null) return result;
                                return new WidgetDrillDownAdapter(widgetName, project, Boolean.valueOf(predefined).booleanValue());
                            }
                            this.throwException("projectId");
                            return result;
                        }
                        this.throwException(currentAttributeName);
                        return result;
                    }
                    this.throwException(currentAttributeName);
                }
            }
            return result;
        } else {
            this.throwException(currentAttributeName);
        }
        return result;
    }

    private Object throwException(String missingAttName) throws Exception {
        throw new Exception("Mandatory " + missingAttName + " attribute not present on DrillDown tag.");
    }

    private boolean validString(String value) {
        return value != null && value.length() > 0;
    }
}

