/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.dashboard;

import java.io.IOException;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class SerializationUtils {
    static void writeColor(XmlWriter writer, String id, ColorInfo color) throws IOException {
        if (color != null) {
            writer.startElement("Color");
            writer.printAttribute("id", id);
            writer.printAttribute("rgb", color.getRgb());
            writer.endElement();
        }
    }

    static void writeFont(XmlWriter writer, String id, FontInfo font) throws IOException {
        if (font != null) {
            writer.setIgnoreEmpty(false);
            writer.startElement("Font");
            writer.printAttribute("id", id);
            writer.printAttribute("name", font.getName());
            writer.printAttribute("style", font.getStyle());
            writer.printAttribute("size", font.getSize());
            writer.setIgnoreEmpty(true);
            writer.endElement();
        }
    }

    static void writeBorder(XmlWriter writer, FullBorderProperties border) throws IOException {
        writer.startElement("FullBorderPropertiesImpl");
        writer.printAttribute("bottomStyle", (Enum)border.getBottomStyle());
        writer.printAttribute("leftStyle", (Enum)border.getLeftStyle());
        writer.printAttribute("rightStyle", (Enum)border.getRightStyle());
        writer.printAttribute("topStyle", (Enum)border.getTopStyle());
        writer.printAttribute("bottomColor", border.getBottomColor());
        writer.printAttribute("leftColor", border.getLeftColor());
        writer.printAttribute("rightColor", border.getRightColor());
        writer.printAttribute("topColor", border.getTopColor());
        writer.printAttribute("bottomWidth", border.getBottomWidth());
        writer.printAttribute("leftWidth", border.getLeftWidth());
        writer.printAttribute("rightWidth", border.getRightWidth());
        writer.printAttribute("topWidth", border.getTopWidth());
        writer.endElement();
    }
}

