/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.dashboard;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.dashboard.SerializationUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlWriter;

public class DashboardSerializer {
    public static void save(DashboardModel dashboard) {
        Project project = dashboard.getProject();
        ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
        if (repository.isOpen(project)) {
            ProjectWriter projectWriter = project.getWriter();
            try {
                projectWriter.write(new ProjectObject[]{dashboard});
            }
            catch (ProjectException e) {
                Log.logFatal((Throwable)((Object)e));
            }
        }
    }

    public static void serializeToFile(Writer w, DashboardModel dashboardModel) throws IOException {
        XmlWriter xw = new XmlWriter(w, Literals.DEFAULT_ENCODING);
        DashboardSerializer.serializeToXml(xw, dashboardModel);
        xw.flush();
        xw.close();
    }

    public static void serializeToXml(XmlWriter writer, DashboardModel dashboard) throws IOException {
        writer.startDocument();
        writer.startElement("DashboardModel");
        writer.printAttribute("name", dashboard.getName());
        writer.printAttribute("rows", dashboard.getRows());
        writer.printAttribute("columns", dashboard.getColumns());
        writer.startElement("descriptions");
        writer.printLocalizedElements("description", dashboard.getLocalizedDescriptions());
        writer.endElement();
        SerializationUtils.writeColor(writer, "background", dashboard.getBackground());
        SerializationUtils.writeColor(writer, "titleBackground", dashboard.getTitleBackground());
        SerializationUtils.writeColor(writer, "titleForeground", dashboard.getTitleForeground());
        SerializationUtils.writeFont(writer, "titleFont", dashboard.getTitleFont());
        List widgetList = dashboard.getWidgetList();
        if (widgetList != null) {
            writer.startElement("Widgets");
            for (int i = 0; i < widgetList.size(); ++i) {
                WidgetModel widget = (WidgetModel)widgetList.get(i);
                if (widget == null) continue;
                writer.startElement("Widget");
                writer.printAttribute("name", widget.getName());
                writer.endElement();
            }
            writer.endElement();
        }
        writer.startElement("titles");
        writer.printLocalizedElements("title", dashboard.getLocalizedTitles());
        writer.endElement();
        writer.endElement();
    }

    public static void remove(DashboardModel dashboardToRemove) {
        Project project = dashboardToRemove.getProject();
        ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
        if (repository.isOpen(project)) {
            ProjectWriter projectWriter = project.getWriter();
            try {
                projectWriter.delete(new ProjectObject[]{dashboardToRemove});
            }
            catch (ProjectException e) {
                Log.logFatal((Throwable)((Object)e));
            }
        }
    }
}

