/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.bpm.analytics.measurement.metadata.model.Measurements;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.sensor.MeasurementActionsFileGenerator;
import oracle.bpm.project.io.sensor.ProcessSensorsVisitor;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;

public class MeasurementsFileGenerator {
    private VFile measurementsFile;
    private Project project;
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class});
    private static final String file = "measurements.xml";

    public MeasurementsFileGenerator(@NotNull Project project) {
        this.project = project;
    }

    public static VFile getMeasurementsFile(Project project) {
        VFileSystem dataFileSystem = project.getWriter().getProjectFileSystem().getDataFileSystem();
        return dataFileSystem.createFile(dataFileSystem.getRoot(), file);
    }

    public void generateFile() {
        Measurements measurements = this.generateMeasurementsFile(this.project);
        MeasurementActionsFileGenerator measurementActionfileGenerator = new MeasurementActionsFileGenerator(this.project);
        measurementActionfileGenerator.generateFile(measurements);
    }

    public VFile getMeasurementsFile() {
        return this.measurementsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Measurements generateMeasurementsFile(Project project) {
        OutputStreamWriter writer = null;
        VFileOutputStream outputStream = null;
        this.measurementsFile = MeasurementsFileGenerator.getMeasurementsFile(project);
        Measurements measurements = this.getRootJaxbElement(project);
        try {
            outputStream = new VFileOutputStream(this.measurementsFile);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            JAXBContext jaxbContext = JAXB_CONTEXT;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)measurements, (Writer)writer);
        }
        catch (IOException e) {
            Log.logSevere((Throwable)e);
            StreamUtils.close((Closeable[])new Closeable[]{outputStream});
            StreamUtils.close((Closeable[])new Closeable[]{writer});
        }
        catch (JAXBException e2) {
            Log.logSevere((Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{outputStream});
                    StreamUtils.close((Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{outputStream});
            StreamUtils.close((Closeable[])new Closeable[]{writer});
        }
        StreamUtils.close((Closeable[])new Closeable[]{outputStream});
        StreamUtils.close((Closeable[])new Closeable[]{writer});
        return measurements;
    }

    private Measurements getRootJaxbElement(Project project) {
        ProcessSensorsVisitor processSensorsVisitor = new ProcessSensorsVisitor(project);
        try {
            processSensorsVisitor.visit();
        }
        catch (ProjectException e) {
            Log.logSevere((Throwable)((Object)e));
        }
        return processSensorsVisitor.getMeasurements();
    }
}

