/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.recognizer.InputSource;
import oracle.bpm.project.io.recognizer.Recognizer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.deployment.DeploymentDescriptor;
import oracle.bpm.project.model.presentation.PresentationPreferences;

class FileNameRecognizer
extends Recognizer.Default {
    private final Map<String, Class<? extends ProjectObject>> nameToClass = new TreeMap<String, Class<? extends ProjectObject>>(String.CASE_INSENSITIVE_ORDER);

    FileNameRecognizer() {
        this.fillNamesMap();
    }

    @Override
    public Class<? extends ProjectObject> recognize(InputSource inputSource) {
        Class<? extends ProjectObject> result = null;
        String name = inputSource.getFileName();
        if (!Str.isEmpty((String)name)) {
            result = this.nameToClass.get(name);
        }
        return result;
    }

    private void fillNamesMap() {
        this.nameToClass.put("preferences.xml", ProjectPreferences.class);
        this.nameToClass.put("presentationPreferences.xml", PresentationPreferences.class);
        this.nameToClass.put("organization.xml", Organization.class);
        this.nameToClass.put("deploymentDescriptor.xml", DeploymentDescriptor.class);
    }
}

