/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializerFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class TopologyWriter
extends AbstractWriter {
    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        ProjectObjectSerializer serializer = ProjectObjectSerializerFactory.getSerializer(object);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
        serializer.write(writer, object);
        writer.flush();
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof Topology) : "projectObject must be instance of Topology";
        return projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem().createFile("publication.xml");
    }
}

