/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.io.fs.FileProjectLoader;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={CatalogObject.class})
public class CatalogWriter
extends AbstractWriter {
    @Override
    public boolean canWrite(ProjectObject projectObject) throws ProjectException {
        return true;
    }

    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        if (projectObject == null) {
            throw new IllegalArgumentException("Null catalog object");
        }
        Boolean processingCatalogEvent = (Boolean)FileProjectLoader.processingCatalogEvent.get();
        if (processingCatalogEvent != null && processingCatalogEvent.booleanValue()) {
            return (VFile)((ProjectObjectImpl)projectObject).as(VFile.class);
        }
        assert (projectObject instanceof CatalogObject) : "projectObject must be instance of CatalogObject";
        try {
            ObjectTypeDescription type = ((CatalogObject)projectObject).getObjectType();
            assert (type != null) : "Catalog object does not have an object type: " + type;
            MutableComponentCatalog catalog = (MutableComponentCatalog)type.getCatalog();
            assert (catalog != null) : "Catalog type does not have a component catalog: " + type;
            ObjectTypeDescription parentType = type.getParent().asObject();
            if (!catalog.containsType(type.getText())) {
                catalog.add(type);
                if (parentType.findInnerType(type.getName()) == null) {
                    parentType.addInnerType((TypeRef)type);
                }
            } else {
                catalog.update(type);
            }
            return catalog.getFileForType(type.getText());
        }
        catch (TypeCatalogException e) {
            throw ProjectException.wrap(projectObject, e);
        }
    }

    @Override
    public void delete(ProjectObject projectObject) throws ProjectException {
        CatalogObject catalogObject = (CatalogObject)projectObject;
        MutableComponentCatalog catalog = (MutableComponentCatalog)projectObject.getProject().getComponentCatalog();
        try {
            TypeRef type;
            String typeName = catalogObject.getText();
            if (catalog.containsType(typeName) && (type = catalog.find(typeName)) != null) {
                ObjectTypeDescription parent = type.get().getParent().asObject();
                catalog.remove(typeName);
                parent.removeInnerType(type);
            }
        }
        catch (AmbiguousTypeNameException e) {
            throw ProjectException.wrap((ProjectObject)catalogObject, e);
        }
        catch (TypeCatalogException e) {
            throw ProjectException.wrap((ProjectObject)catalogObject, e);
        }
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof CatalogObject) : "projectObject must be instance of CatalogObject";
        CatalogObject catalogObject = (CatalogObject)projectObject;
        try {
            MutableComponentCatalog catalog = (MutableComponentCatalog)projectObject.getProject().getComponentCatalog();
            return catalog.getFileForType(catalogObject.getText());
        }
        catch (TypeCatalogException e) {
            throw ProjectException.wrap((ProjectObject)catalogObject, e);
        }
    }
}

