/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.migration;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.OrganizationObject;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.presentation.views.ViewManager;

public abstract class AbstractProjectMigrationManager<R extends ProjectRepository> {
    private R repository;

    protected AbstractProjectMigrationManager(R repository) {
        this.repository = repository;
    }

    public void migrate57Project(Project project) throws ProjectException {
        this.migrateOrganization(project);
        this.migrateViews(project);
        this.migratePresentations(project);
        this.migrateProjectModel(project);
        this.migrateEngine(project);
        this.migrateExternalResources(project);
        this.migrateProcesses(project);
    }

    public R getRepository() {
        return this.repository;
    }

    protected abstract void migrateExternalResources(Project var1) throws ProjectException;

    protected abstract void deleteXMLResourceForObject(ProjectObject var1);

    protected abstract void cleanOldMigratedFiles(Project var1, Path var2) throws ProjectException;

    protected abstract void cleanOldMigratedFolders(Project var1, Path var2) throws ProjectException;

    protected abstract void migrateEngine(Project var1) throws ProjectException;

    protected abstract void cleanAdapters(ProjectObject var1);

    protected abstract void addToRepositoryProjectObjectLoadedMap(ProjectObject var1);

    protected abstract void migrateProcesses(Project var1) throws ProjectException;

    private void migrateProjectModel(Project project) throws ProjectException {
        project.getWriter().write(project.getProjectModel());
        for (ProjectDataObject projectDataObject : project.getAllVariables()) {
            this.deleteXMLResourceForObject(projectDataObject);
        }
    }

    private void migratePresentations(Project project) throws ProjectException {
        project.getPresentationManager();
        for (Presentation presentation : project.getPresentationManager().getPresentations()) {
            if (!presentation.isCustom()) continue;
            this.cleanAdapters(presentation);
            project.getWriter().write(presentation);
            this.addToRepositoryProjectObjectLoadedMap(presentation);
            this.deleteXMLResourceForObject(presentation);
        }
    }

    private void migrateViews(Project project) throws ProjectException {
        try {
            project.getViewManager();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        ViewManager viewManager = project.getViewManager();
        List<View> views = viewManager.getViews();
        views = new ArrayList<View>(views);
        for (View view : views) {
            if (view.isCustom()) {
                this.cleanAdapters(view);
                project.getWriter().write(view);
                this.addToRepositoryProjectObjectLoadedMap(view);
                continue;
            }
            viewManager.removeView(view);
            this.deleteXMLResourceForObject(view);
        }
        this.cleanOldMigratedFiles(project, Path.VIEW);
        this.cleanOldMigratedFolders(project, Path.VIEW);
    }

    private void migrateOrganization(Project project) throws ProjectException {
        Organization organization = project.getOrganization();
        for (OrganizationObject organizationObject : organization.getAllOrganizationObjects()) {
            this.cleanAdapters(organizationObject);
            project.getWriter().write(organizationObject);
            this.addToRepositoryProjectObjectLoadedMap(organizationObject);
            this.deleteXMLResourceForObject(organizationObject);
        }
    }
}

