/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.sensor.MeasurementActionsLoader;
import oracle.bpm.project.model.ExceptionHandlingType;
import oracle.bpm.project.model.LaneOrientation;
import oracle.bpm.project.model.ProjectGenerateEvents;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.Locales;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@ProjectObjectLoaderMetadata(objectClasses={ProjectPreferences.class})
public class ProjectPreferencesLoader
extends ProjectObjectLoader<ProjectPreferences> {
    @Override
    public ProjectPreferences create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return this.getProject().getPreferences();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectPreferences loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        ProjectPreferences preferences = this.create(container, file);
        preferences.setId(VFileUtils.getName((VFile)file));
        ProjectPreferencesHandler handler = new ProjectPreferencesHandler(preferences);
        VFileInputStream inputStream = null;
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            inputStream = new VFileInputStream(file);
            reader.parse(new InputSource((InputStream)inputStream));
        }
        catch (ParserConfigurationException e) {
            try {
                throw ProjectException.wrap((ProjectObject)preferences, e);
                catch (IOException e2) {
                    throw ProjectException.wrap((ProjectObject)preferences, e2);
                }
                catch (SAXException e3) {
                    throw ProjectException.wrap((ProjectObject)preferences, e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        new MeasurementActionsLoader(preferences.getProject()).loadMeasurementActions();
        return preferences;
    }

    private static class ProjectPreferencesHandler
    extends DefaultHandler {
        private ProjectPreferences projectPreferences;
        private static final String EXCEPTION_HANDLING_POLICY = "exceptionHandlingPolicy";
        private static final String SHARING_PREDEFINED_VARIABLES_DEFAULT = "sharingPredefinedVariablesDefault";
        private static final String J2EEMODE = "J2EEMode";
        private static final String ISTEMPLATE = "IsTemplate";

        public ProjectPreferencesHandler(ProjectPreferences projectPreferences) {
            this.projectPreferences = projectPreferences;
        }

        @Override
        public void startElement(String uri, String local, String name, Attributes amap) throws SAXException {
            if (name.equals("processes")) {
                this.manageProcessesInfo(amap);
            } else if (name.equals("languages")) {
                this.manageLanguageContext(amap);
            } else if (name.equals("activity")) {
                this.manageActivityContext(amap);
            } else if (name.equals("general")) {
                this.manageGeneralInfo(amap);
            } else if (name.equals("dependencies")) {
                this.manageDependenciesInfo(amap);
            } else if (name.equals("generateEvents")) {
                this.manageGenerateEventsInfo(amap);
            }
        }

        private void manageGenerateEventsInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("type")) continue;
                try {
                    this.projectPreferences.getKeyPerformanceIndicatorsContainer().setGenerateEvents(ProjectGenerateEvents.valueOf(value));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.projectPreferences.getKeyPerformanceIndicatorsContainer().setGenerateEvents(ProjectGenerateEvents.GENERATE_INTERACTIVE_EVENTS);
                }
            }
        }

        private void manageActivityContext(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("allowReadWriteOptionalTasks")) continue;
                this.projectPreferences.setAllowReadWriteOptionalTasks(Boolean.valueOf(value));
            }
        }

        private void manageGeneralInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals(J2EEMODE)) {
                    this.projectPreferences.setJ2EEMode(Boolean.valueOf(value));
                    continue;
                }
                if (!attname.equals(ISTEMPLATE)) continue;
                this.projectPreferences.setTemplate(Boolean.valueOf(value));
            }
        }

        private void manageLanguageContext(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals("default")) {
                    this.projectPreferences.setDefaultLanguage(Locales.valueOf((String)value));
                    continue;
                }
                if (!attname.equals("availables")) continue;
                ArrayList<Locale> list = new ArrayList<Locale>();
                StringTokenizer st = new StringTokenizer(value, ";");
                while (st.hasMoreTokens()) {
                    list.add(Locales.valueOf((String)st.nextToken()));
                }
                this.projectPreferences.setAvailableLanguages(list);
            }
        }

        private void manageDependenciesInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!attname.equals("projects")) continue;
                ArrayList<String> projects = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(value, ";");
                while (st.hasMoreTokens()) {
                    String id = st.nextToken();
                    projects.add(id);
                }
                this.projectPreferences.setDependencies(projects);
            }
        }

        private void manageProcessesInfo(Attributes amap) {
            boolean hasLanesOrientationAttribute = false;
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (attname.equals("generatesInteractiveRole")) {
                    this.projectPreferences.setGeneratesInteractiveRole(Boolean.valueOf(value));
                    continue;
                }
                if (attname.equals("interactiveRole")) {
                    this.projectPreferences.setInteractiveRole(value);
                    continue;
                }
                if (attname.equals("lanesOrientation")) {
                    hasLanesOrientationAttribute = true;
                    this.projectPreferences.setLanesOrientation(LaneOrientation.valueOf(value));
                    continue;
                }
                if (attname.equals(EXCEPTION_HANDLING_POLICY)) {
                    if (value.equals("IGNORE")) {
                        this.projectPreferences.setExceptionHandlingType(ExceptionHandlingType.PROPAGATE);
                        continue;
                    }
                    this.projectPreferences.setExceptionHandlingType(ExceptionHandlingType.valueOf(value));
                    continue;
                }
                if (!attname.equals(SHARING_PREDEFINED_VARIABLES_DEFAULT)) continue;
                this.projectPreferences.setAllowsNotToShareInstanceVars(Boolean.valueOf(value));
            }
            if (!hasLanesOrientationAttribute) {
                this.projectPreferences.setLanesOrientation(LaneOrientation.VERTICAL);
            }
        }
    }
}

