/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.log.Log;
import oracle.bpm.project.PresentationPreferencesImpl;
import oracle.bpm.project.io.fs.PresentationsPreferencesHandler;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.PresentationPreferences;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ProjectObjectLoaderMetadata(objectClasses={PresentationPreferences.class})
public class PresentationPreferencesLoader
extends ProjectObjectLoader<PresentationPreferences> {
    @Override
    public PresentationPreferences create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return new PresentationPreferencesImpl(this.getProject());
    }

    @Override
    public PresentationPreferences loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        PresentationPreferences presentationPreferences = this.create(container, file);
        PresentationsPreferencesHandler handler = new PresentationsPreferencesHandler(presentationPreferences);
        this.parseXmlFile(file, handler, false);
        return presentationPreferences;
    }

    private void parseXmlFile(VFile file, DefaultHandler handler, boolean validating) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validating);
            VFileInputStream fileInputStream = new VFileInputStream(file);
            InputSource inputSource = new InputSource((InputStream)fileInputStream);
            factory.newSAXParser().parse(inputSource, handler);
        }
        catch (SAXException e) {
            Log.logWarning((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Log.logWarning((Throwable)e);
        }
        catch (IOException e) {
            Log.logWarning((Throwable)e);
        }
    }
}

