/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.io.serializers.simulation.model.PersistentModelSimulation;
import oracle.bpm.project.model.ModelSimulationProcess;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={ModelSimulation.class})
public class ModelSimulationsLoader
extends ProjectObjectLoader<ModelSimulation> {
    @Override
    public ModelSimulation create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        String modelId = this.getModelIdFrom(container);
        return container.createModelSimulation(modelId, "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModelSimulation loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        ModelSimulation modelSimulation;
        VFileInputStream fileInputStream;
        InputStreamReader inputStreamReader;
        BufferedReader reader;
        block7: {
            ModelSimulation modelSimulation2;
            String modelId = this.getModelIdFrom(container);
            reader = null;
            inputStreamReader = null;
            fileInputStream = null;
            modelSimulation = null;
            try {
                fileInputStream = new VFileInputStream(file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Literals.DEFAULT_ENCODING);
                reader = new BufferedReader(inputStreamReader);
                if (modelId != null) {
                    modelSimulation = PersistentModelSimulation.buildFrom(reader, container, modelId);
                    break block7;
                }
                Log.logSevere((Msg)ProjectMsg.MODEL_NOT_FOUND_FOR_SIMULATION((String)file.getName()));
                modelSimulation2 = null;
            }
            catch (FileNotFoundException e) {
                try {
                    throw ProjectException.wrap((ProjectObject)this.getProject(), e);
                    catch (UnsupportedEncodingException e2) {
                        throw ProjectException.wrap((ProjectObject)this.getProject(), e2);
                    }
                    catch (IOException e3) {
                        throw ProjectException.wrap((ProjectObject)this.getProject(), e3);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{reader});
                    StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
                    StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
                    throw throwable;
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{reader});
            StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
            StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
            return modelSimulation2;
        }
        StreamUtils.close((Closeable[])new Closeable[]{reader});
        StreamUtils.close((Closeable[])new Closeable[]{inputStreamReader});
        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
        return modelSimulation;
    }

    private Process getModelFrom(VFile file) {
        String name = FileUtils.removeExtension((String)file.getName());
        String[] nameParts = name.split("_");
        return this.getProject().findProcess(nameParts[0]);
    }

    private String getModelIdFrom(ResourceContainer container) {
        if (container instanceof ModelSimulationProcess) {
            return container.getId();
        }
        return null;
    }
}

