/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.log.Log;
import oracle.bpm.project.forms.FormImpl;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.forms.Form;
import oracle.bpm.type.FormLoader45;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ProjectObjectLoaderMetadata(objectClasses={Form.class})
public class FormLoader
extends ProjectObjectLoader<Form> {
    private SAXParser saxParser;

    public FormLoader() {
        try {
            this.saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            Log.logDebug((Throwable)e);
        }
        catch (SAXException e) {
            Log.logDebug((Throwable)e);
        }
    }

    @Override
    public Form create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Form loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        VFileInputStream fileInputStream = null;
        ProjectObject[] newProjectObject = new ProjectObject[]{null};
        try {
            fileInputStream = new VFileInputStream(file);
            InputSource inputSource = new InputSource((InputStream)fileInputStream);
            FormLoader45 loader = new FormLoader45(true);
            DefaultHandler handler = loader.createDefaultHandler(file.getName());
            this.getSaxParser().parse(inputSource, handler);
            Collection values = loader.getPresentations().values();
            XFormPresentationModel[] models = values.toArray(new XFormPresentationModel[1]);
            newProjectObject[0] = new FormImpl(container.getProject(), models[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
        }
        catch (SAXException e2) {
            block6: {
                if (e2.getException() == null) break block6;
                e2.initCause(e2.getException());
                {
                    catch (Throwable throwable) {
                        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
                        throw throwable;
                    }
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
        }
        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
        return (Form)newProjectObject[0];
    }

    private SAXParser getSaxParser() {
        return this.saxParser;
    }
}

