/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractChangeManager;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.project.model.fojsp.WebContent;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.util.FileUtils;

public class WebContentChangeManager
extends AbstractChangeManager {
    private WebContentChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static WebContentChangeManager create(AbstractProjectRepository repository, Project project) {
        return new WebContentChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        ProjectFileSystem projectFileSystem = this.getLoader().getProjectFileSystem();
        LocalFileSystem localFileSystem = projectFileSystem.getLocalFileSystem();
        String webContentPath = resourceFile.getAbsolutePath().replace(localFileSystem.getRootFolder().getAbsolutePath(), "");
        return resourceFile.isFile() && Path.WEB_ROOT.getName().equals(Path.getPath(new File(webContentPath)).getParts()[0]);
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        WebContent webContent = (WebContent)projectObject;
        WebContainer.Mutable parent = webContent.getParent().asMutable();
        parent.addWebContent(webContent);
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        String fileName = FileUtils.getName((File)resourceFile);
        Path parentPath = Path.getPath(resourceFile.getParentFile());
        WebContainer parent = (WebContainer)super.getProject().getWebRootContainer().findContainer(parentPath);
        return parent != null ? parent.findWebContent(fileName, WebContentType.valueOfFileExtension(FileUtils.getExtension((File)resourceFile))) : null;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WEB_CONTENT;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        return false;
    }
}

