/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractChangeManager;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.util.FileUtils;

public class WebContainerChangeManager
extends AbstractChangeManager {
    private WebContainerChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static WebContainerChangeManager create(AbstractProjectRepository repository, Project project) {
        return new WebContainerChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isDirectory() && Path.WEB_ROOT.getName().equals(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        WebContainer webContainer = (WebContainer)projectObject;
        webContainer.getParent().asMutable().addContainer(webContainer);
        return true;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        ProjectFileSystem projectFileSystem = this.getLoader().getProjectFileSystem();
        LocalFileSystem localFileSystem = projectFileSystem.getLocalFileSystem();
        String webContainerFile = resourceFile.getAbsolutePath().replace(localFileSystem.getRootFolder().getAbsolutePath(), "");
        Path webContainerPath = Path.getPath(new File(webContainerFile));
        Container webContainer = super.getProject().getWebRootContainer().findContainer(webContainerPath);
        return webContainer;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WEB_CONTAINER;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        return false;
    }
}

