/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractProcessChangeManager;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.FileUtils;

public class ModelContainerChangeManager
extends AbstractProcessChangeManager {
    private ModelContainerChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static ModelContainerChangeManager create(AbstractProjectRepository repository, Project project) {
        return new ModelContainerChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isDirectory() && Path.PROCESSES.getName().equals(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        FolderContainer folderContainer = (FolderContainer)projectObject;
        ((ProjectObjectContainer)folderContainer.getParentObject()).addChild(folderContainer);
        return true;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        ProjectObject folderContainer = null;
        return folderContainer;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL_CONTAINER;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        this.getProject().replace(projectObject);
        return false;
    }
}

