/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractOrganizationChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.FileUtils;

public class HolidayRuleChangeManager
extends AbstractOrganizationChangeManager {
    private HolidayRuleChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static HolidayRuleChangeManager create(AbstractProjectRepository repository, Project project) {
        return new HolidayRuleChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xhdl".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        if (this.getOrganization().findHolidayRule(projectObject.getId()) == null) {
            super.getOrganization().addOrganizationalObject(projectObject);
        }
        return false;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.HOLIDAY_RULE;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return super.getOrganization().findHolidayRule(FileUtils.getName((File)resourceFile));
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }
}

