/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.ActivityInstancesViewChangeManager;
import oracle.bpm.project.io.fs.events.ApplicationsViewChangeManager;
import oracle.bpm.project.io.fs.events.AttachmentsViewChangeManager;
import oracle.bpm.project.io.fs.events.BusinessParameterChangeManager;
import oracle.bpm.project.io.fs.events.CalendarRuleChangeManager;
import oracle.bpm.project.io.fs.events.ChangeManager;
import oracle.bpm.project.io.fs.events.EngineChangeManager;
import oracle.bpm.project.io.fs.events.ExternalResourceChangeManager;
import oracle.bpm.project.io.fs.events.FoldersViewChangeManager;
import oracle.bpm.project.io.fs.events.GroupChangeManager;
import oracle.bpm.project.io.fs.events.HolidayRuleChangeManager;
import oracle.bpm.project.io.fs.events.InstancesViewChangeManager;
import oracle.bpm.project.io.fs.events.ModelChangeManager;
import oracle.bpm.project.io.fs.events.ModelContainerChangeManager;
import oracle.bpm.project.io.fs.events.ModelSimulationChangeManager;
import oracle.bpm.project.io.fs.events.OrganizationalUnitChangeManager;
import oracle.bpm.project.io.fs.events.ParticipantChangeManager;
import oracle.bpm.project.io.fs.events.PresentationChangeManager;
import oracle.bpm.project.io.fs.events.ProjectPreferencesChangeManager;
import oracle.bpm.project.io.fs.events.ProjectSimulationChangeManager;
import oracle.bpm.project.io.fs.events.RoleChangeManager;
import oracle.bpm.project.io.fs.events.TopologyChangeManager;
import oracle.bpm.project.io.fs.events.WebContainerChangeManager;
import oracle.bpm.project.io.fs.events.WebContentChangeManager;
import oracle.bpm.project.model.Project;

class ChangeManagers {
    private List<ChangeManager> changeManagerList;

    private ChangeManagers(AbstractProjectRepository repository, Project project) {
        this.changeManagerList = this.init(repository, project);
    }

    public static ChangeManagers create(AbstractProjectRepository repository, Project project) {
        return new ChangeManagers(repository, project);
    }

    public ChangeManager getChangeManager(File resourceFile) {
        for (ChangeManager changeManager : this.changeManagerList) {
            if (!changeManager.isValid(resourceFile)) continue;
            return changeManager;
        }
        return null;
    }

    public List<ChangeManager> init(AbstractProjectRepository repository, Project project) {
        ArrayList<ChangeManager> result = new ArrayList<ChangeManager>();
        result.add(ModelChangeManager.create(repository, project));
        result.add(ModelContainerChangeManager.create(repository, project));
        result.add(ModelSimulationChangeManager.create(repository, project));
        result.add(ProjectSimulationChangeManager.create(repository, project));
        result.add(ExternalResourceChangeManager.create(repository, project));
        result.add(OrganizationalUnitChangeManager.create(repository, project));
        result.add(RoleChangeManager.create(repository, project));
        result.add(GroupChangeManager.create(repository, project));
        result.add(ParticipantChangeManager.create(repository, project));
        result.add(HolidayRuleChangeManager.create(repository, project));
        result.add(CalendarRuleChangeManager.create(repository, project));
        result.add(WebContainerChangeManager.create(repository, project));
        result.add(WebContentChangeManager.create(repository, project));
        result.add(BusinessParameterChangeManager.create(repository, project));
        result.add(EngineChangeManager.create(repository, project));
        result.add(ProjectPreferencesChangeManager.create(repository, project));
        result.add(TopologyChangeManager.create(repository, project));
        result.add(PresentationChangeManager.create(repository, project));
        result.add(ApplicationsViewChangeManager.create(repository, project));
        result.add(ActivityInstancesViewChangeManager.create(repository, project));
        result.add(AttachmentsViewChangeManager.create(repository, project));
        result.add(InstancesViewChangeManager.create(repository, project));
        result.add(FoldersViewChangeManager.create(repository, project));
        return result;
    }
}

