/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.util.FileUtils;

public class BusinessParameterChangeManager
extends AbstractChangeManager {
    private BusinessParameterChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static BusinessParameterChangeManager create(AbstractProjectRepository repository, Project project) {
        return new BusinessParameterChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xbpdl".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        if (this.getProject().getBusinessParametersContainer().findChild(BusinessParameter.class, projectObject.getId()) == null) {
            this.getProject().getBusinessParametersContainer().addChild(projectObject);
        }
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return this.getProject().getBusinessParametersContainer().findChild(BusinessParameter.class, FileUtils.getName((File)resourceFile));
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.BUSINESS_PARAMETER;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }
}

