/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.JarWrapper;

public class RuntimeResourcesHelper {
    private static final String RUNTIME_RESOURCES_DIRECTORY = "runtime";
    private static final String RESOURCES_DIRECTORY = "resources";

    public static File[] getRuntimeResourcesFiles(ProjectWriter projectWriter) {
        List files = FileUtils.getFilesRecursively((File)RuntimeResourcesHelper.getRuntimeResourcesDir(projectWriter), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        }, (boolean)true, (boolean)false);
        return files.toArray(new File[files.size()]);
    }

    public static void createRuntimeResourcesJar(ProjectWriter projectWriter, String jarFile) throws IOException {
        File runtimeResourcesDir = RuntimeResourcesHelper.getRuntimeResourcesDir(projectWriter);
        RuntimeResourcesHelper.createJar(jarFile, runtimeResourcesDir.getParentFile(), runtimeResourcesDir);
    }

    private static File getRuntimeResourcesDir(ProjectWriter projectWriter) {
        File runtimeResourcesDirectory = new File(projectWriter.getProjectFileSystem().getLocalFileSystem().getRootFolder(), RESOURCES_DIRECTORY + File.separator + RUNTIME_RESOURCES_DIRECTORY);
        if (!runtimeResourcesDirectory.exists()) {
            runtimeResourcesDirectory.mkdirs();
        }
        return runtimeResourcesDirectory;
    }

    private static void createJar(String jarFile, File directoryRoot, final File runtimeResourcesDir) throws IOException {
        File f = new File(jarFile);
        if (f.exists()) {
            f.delete();
        }
        JarWrapper jar = JarWrapper.createJar((String)jarFile);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getAbsolutePath().startsWith(runtimeResourcesDir.getAbsolutePath());
            }
        };
        jar.addDirectoryTree(directoryRoot, filter, true);
        jar.flush();
        jar.close();
    }
}

