/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.File;
import oracle.bpm.extensionpoint.metadata.ProjectRepositoryMetadata;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.io.fs.NoCatalogLoader;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

@ProjectRepositoryMetadata(type="no-catalog")
public class NoCatalogProjectRepository
extends FileProjectRepository {
    private static FileProjectRepository instance;

    private NoCatalogProjectRepository(File baseDir) {
        super(baseDir);
    }

    public static NoCatalogProjectRepository create(File baseDir) {
        return new NoCatalogProjectRepository(baseDir);
    }

    public static FileProjectRepository getOrCreate(File baseDir) {
        if (instance == null || !instance.getDefaultBaseDir().equals(baseDir)) {
            return NoCatalogProjectRepository.create(baseDir);
        }
        return instance;
    }

    @Override
    protected ProjectLoader createLoader(Project project, @NotNull ProjectFileSystem fileSystem) {
        return new NoCatalogLoader(this, project, fileSystem);
    }

    @Override
    protected void createProjectFiles(Project project, ProjectFileSystem fileSystem) throws ProjectException {
    }
}

