/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Platform;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.io.fs.FileProjectLoader;
import oracle.bpm.project.io.fs.ProjectObjectsCache;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.io.serializers.organization.ProjectObjectWriter;
import oracle.bpm.project.model.CompositeObject;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileProjectWriter
implements ProjectWriter {
    private Project project;
    private ProjectFileSystem projectFileSystem;
    private ProjectChangeAdapter projectListener;
    private ProjectRepository repository;
    private Map<Class<? extends ProjectObject>, ProjectObjectWriter> writers = new HashMap<Class<? extends ProjectObject>, ProjectObjectWriter>();
    public static final String ELEM_PRESENTATION_PREFERENCES = "presentationPreferences";
    public static final String ATTR_INBOX_PRESENTATION_ID = "inboxViewPresentationId";
    public static final String ATTR_PROCESS_PRESENTATION_ID = "processViewsPresentationId";
    public static final String ATTR_ACTIVITY_PRESENTATION_ID = "activityViewsPresentationId";

    public FileProjectWriter(ProjectRepository repository, Project project, ProjectFileSystem fileSystem) {
        this(repository, project, fileSystem, true);
    }

    public FileProjectWriter(ProjectRepository repository, Project project, ProjectFileSystem fileSystem, boolean shouldListen) {
        this.repository = repository;
        this.project = project;
        this.projectFileSystem = fileSystem;
        if (shouldListen) {
            this.startProjectListener();
        }
    }

    public static FileFilter getSchemasFileFilter(final boolean allowDirs, final boolean allowVisioFiles) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean result;
                boolean bl = result = allowDirs && pathname.isDirectory();
                if (!result) {
                    String fileName = pathname.getName().toLowerCase();
                    String extension = FileUtils.getExtension((File)pathname);
                    result = FileProjectWriter.isValidProcessFileName(fileName, extension, allowVisioFiles);
                }
                return result;
            }
        };
    }

    @Override
    public ProjectRepository getProjectRepository() {
        return this.repository;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public boolean isWritable(ProjectObject projectObject) {
        return projectObject != null && this.getProjectWriter(projectObject.getRawClass()) != null;
    }

    @Override
    public boolean hasMarkerErrors(File file) throws ProjectException {
        return false;
    }

    @Override
    public void write(ProjectObject ... object) throws ProjectException {
        for (ProjectObject projectObject : object) {
            this.performWriting(projectObject);
        }
    }

    @Override
    public VFile getFile(@NotNull ProjectObject projectObject) throws ProjectException {
        ProjectObjectWriter objectWriter = this.getProjectWriter(projectObject.getRawClass());
        VFile result = null;
        if (objectWriter != null && (result = objectWriter.getFile(projectObject)) != null) {
            try {
                FileProjectWriter.adaptProjectObject(projectObject, URL.class, result.toURL());
            }
            catch (IOException e) {
                throw ProjectException.wrap(projectObject, e);
            }
        }
        return result;
    }

    @Override
    public void delete(ProjectObject ... object) throws ProjectException {
        for (ProjectObject projectObject : object) {
            ProjectObjectWriter objectWriter = this.getProjectWriter(projectObject.getRawClass());
            if (objectWriter == null) continue;
            objectWriter.delete(projectObject);
        }
    }

    @Override
    public void dispose() {
        this.stopProjectListener();
    }

    @Override
    public void refresh(ProjectObject projectObject) throws ProjectException {
    }

    @Override
    public void writeSystemObject(Object serializable, String id) throws ProjectException {
        FileOutputStream fos = null;
        ObjectOutputStream objectStream = null;
        try {
            LocalFileSystem localFileSystem = this.getProjectFileSystem().getLocalFileSystem();
            File file = new File(localFileSystem.getSystemFolder(), id + ".ser");
            fos = new FileOutputStream(file);
            objectStream = new ObjectOutputStream(fos);
            objectStream.writeObject(serializable);
        }
        catch (IOException e) {
            try {
                throw ProjectException.wrap((ProjectObject)this.getProject(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{objectStream});
                StreamUtils.close((Closeable[])new Closeable[]{fos});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{objectStream});
        StreamUtils.close((Closeable[])new Closeable[]{fos});
    }

    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        ProjectObjectWriter writer;
        if (!FileProjectWriter.isBroken(object) && (writer = this.getProjectWriter(object.getRawClass())) != null) {
            writer.write(object, outputStream);
        }
    }

    @Override
    public ProjectFileSystem getProjectFileSystem() {
        return this.projectFileSystem;
    }

    public void objectReplaced(ProjectObject oldObject, ProjectObject newObject) {
    }

    @Nullable
    public ProjectObjectsCache getProjectObjectsCache() throws ProjectException {
        ProjectLoader loader = this.getProject().getLoader();
        return loader instanceof FileProjectLoader ? ((FileProjectLoader)loader).getProjectObjectsCache() : null;
    }

    protected static boolean isBroken(ProjectObject object) {
        if (object instanceof ErrorSource) {
            ErrorSource source = (ErrorSource)((Object)object);
            return source.isBroken();
        }
        return false;
    }

    protected void preObjectAdded(ProjectObject object) throws ProjectException {
        ProjectObjectWriter writer = this.getProjectWriter(object.getRawClass());
        if (writer != null && !writer.canWrite(object)) {
            throw new ProjectException(object, ProjectIoMsg.CANNOT_CREATE_FILE(object.getId()));
        }
    }

    protected void preObjectRemoved(ProjectObject object) throws ProjectException {
        try {
            ProjectObjectWriter writer = this.getProjectWriter(object.getRawClass());
            VFile file = this.getFile(object);
            if (file == null || !file.exists()) {
                return;
            }
            if (!writer.canWrite(object)) {
                throw new ProjectException(object, ProjectIoMsg.CANNOT_DELETE_FILE(file.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap(object, e);
        }
    }

    protected void postObjectAdded(ProjectObject object) {
        try {
            this.write(object);
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    protected void postObjectRemoved(ProjectObject object) {
        try {
            this.delete(object);
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    private static boolean isValidProcessFileName(String fileName, String extension, boolean allowVisioFiles) {
        return !fileName.startsWith("~") && (SchemaType.isSupportedSchema((String)extension) || allowVisioFiles && "vdx".equalsIgnoreCase(extension));
    }

    private static boolean isObjectAssociatedToResource(ProjectObject object) {
        boolean result;
        boolean bl = result = object.findResourceObject() == object;
        if (result) {
            if (object instanceof CatalogObjectImpl) {
                CatalogObjectImpl coi = (CatalogObjectImpl)object;
                result = coi.isAssociatedToResource();
            } else if (object instanceof CompositeObject) {
                result = false;
            }
        }
        return result;
    }

    private static <P> void adaptProjectObject(@NotNull ProjectObject projectObject, @NotNull Class<P> adapterClass, @NotNull Object adapter) {
        ProjectObjectImpl adaptableProjectObject;
        Object adaptedObject;
        if (projectObject instanceof ProjectObjectImpl && (adaptedObject = (adaptableProjectObject = (ProjectObjectImpl)projectObject).as(adapterClass)) == null) {
            adaptableProjectObject.addAdapter(adapter);
        }
    }

    private ProjectObjectWriter getProjectWriter(@NotNull Class<? extends ProjectObject> objectClass) {
        if (this.writers.containsKey(objectClass)) {
            return this.writers.get(objectClass);
        }
        ProjectObjectWriter writer = this.createProjectWriter(objectClass);
        if (writer != null) {
            this.writers.put(objectClass, writer);
        }
        return writer;
    }

    private ProjectObjectWriter createProjectWriter(@NotNull Class<? extends ProjectObject> objectClass) {
        ExtensionService service = Platform.getExtensionService();
        List extensions = service.getExtensionsByPoint(ProjectObjectWriterMetadata.class);
        for (Extension extension : extensions) {
            Class<? extends ProjectObject>[] availableClasses;
            for (Class<? extends ProjectObject> availableClass : availableClasses = ((ProjectObjectWriterMetadata)extension.getMetadata()).objectClasses()) {
                if (!availableClass.isAssignableFrom(objectClass)) continue;
                try {
                    return (ProjectObjectWriter)extension.instantiateAs(ProjectObjectWriter.class);
                }
                catch (InstantiationException e) {
                    IllegalStateException iae = new IllegalStateException("Could not create writer for class " + objectClass.toString() + ". Because: " + e);
                    iae.initCause(e);
                    throw iae;
                }
            }
        }
        return null;
    }

    private void performWriting(ProjectObject projectObject) throws ProjectException {
        boolean dirty = ((ResourceObject)((Object)projectObject)).isDirty();
        try {
            Class rawClass = projectObject.getRawClass();
            ProjectObjectWriter writer = this.getProjectWriter(rawClass);
            if (writer != null) {
                VFile vFile = writer.write(projectObject);
                if (this.getRelatedVFile(projectObject) == null && vFile != null) {
                    ProjectObjectImpl.setAdapter((ProjectObject)projectObject, (Object)vFile);
                }
                ((ResourceObject)((Object)projectObject)).setDirty(false);
                ProjectObjectsCache cache = this.getProjectObjectsCache();
                ProjectObject projectObject1 = null;
                if (cache != null && (projectObject1 = cache.getObject(vFile)) != projectObject && vFile != null) {
                    cache.addObjectToCache(vFile, projectObject, rawClass);
                }
            }
        }
        catch (ProjectException e) {
            ((ResourceObject)((Object)projectObject)).setDirty(dirty);
            throw e;
        }
    }

    private void stopProjectListener() {
        if (this.projectListener != null) {
            this.getProject().removeListener(this.projectListener);
            this.projectListener = null;
        }
    }

    private void startProjectListener() {
        if (this.projectListener == null) {
            this.projectListener = new ProjectChangeAdapter();
            this.getProject().addListener(this.projectListener);
        }
    }

    private VFile getRelatedVFile(@NotNull ProjectObject object) {
        return object instanceof Adaptable ? (VFile)((Adaptable)object).as(VFile.class) : null;
    }

    private class ProjectChangeAdapter
    extends ProjectListenerAdapter<ProjectObject> {
        public ProjectChangeAdapter() {
            super(ProjectObject.class);
        }

        @Override
        public void preObjectAdded(ProjectObject object, ProjectObject parent) throws ProjectException {
            if (FileProjectWriter.isObjectAssociatedToResource(object)) {
                FileProjectWriter.this.preObjectAdded(object);
            }
        }

        @Override
        public void preObjectRemoved(ProjectObject object, ProjectObject parent) throws ProjectException {
            if (FileProjectWriter.isObjectAssociatedToResource(object)) {
                FileProjectWriter.this.preObjectRemoved(object);
            }
        }

        @Override
        public void postObjectAdded(ProjectObject object, ProjectObject parent) {
            if (FileProjectWriter.isObjectAssociatedToResource(object)) {
                FileProjectWriter.this.postObjectAdded(object);
            }
        }

        @Override
        public void objectChanged(ProjectObject object, ProjectEvent event) {
            if (this.isAutoSave(object)) {
                FileProjectWriter.this.postObjectAdded(object);
            }
        }

        @Override
        public void objectReplaced(ProjectObject oldObject, ProjectObject newObject) {
            FileProjectWriter.this.objectReplaced(oldObject, newObject);
        }

        @Override
        public void postObjectRemoved(ProjectObject object, ProjectObject parent) {
            if (FileProjectWriter.isObjectAssociatedToResource(object)) {
                FileProjectWriter.this.postObjectRemoved(object);
            }
        }

        private boolean isAutoSave(ProjectObject object) {
            return object instanceof Process && ProcessContent.isDefaultProcess((Process)((Process)object));
        }
    }
}

