/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.project;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.io.serializers.simulation.migrator.ProjectSimulationMigrator;
import oracle.bpm.project.io.serializers.simulation.project.PersistentBaseProjectSimulation;
import oracle.bpm.project.io.serializers.simulation.project.PersistentElementParser;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlparser.UnexpectedContentException;

public class PersistentProjectSimulation
extends PersistentBaseProjectSimulation {
    public PersistentProjectSimulation() {
        NamespaceContext namespaceContext = new NamespaceContext();
        namespaceContext.addNamespace("", this.getNamespace());
        this.setNSContext(namespaceContext);
    }

    public static PersistentProjectSimulation parse(Reader reader) throws ParserException {
        return new PersistentElementParser().parseProjectSimulation(null, reader);
    }

    public static ProjectSimulation buildFrom(Reader reader, Project project) throws ProjectException {
        try {
            PersistentProjectSimulation persistentProjectSimulation;
            try {
                persistentProjectSimulation = PersistentProjectSimulation.parse(reader);
            }
            catch (UnexpectedContentException e) {
                DefaultElement defaultElement = e.getRootAsDefaultElement();
                persistentProjectSimulation = ProjectSimulationMigrator.migrate(defaultElement);
            }
            ProjectSimulation projectSimulation = project.getSimulations().createProjectSimulation(persistentProjectSimulation.getName());
            persistentProjectSimulation.addTo(projectSimulation);
            return projectSimulation;
        }
        catch (ParserException e) {
            throw ProjectException.wrap(e);
        }
    }

    public static ProjectSimulation buildFrom(File file, Project project) throws ProjectException {
        try {
            PersistentProjectSimulation persistentProjectSimulation;
            try {
                persistentProjectSimulation = PersistentProjectSimulation.parse(file);
            }
            catch (UnexpectedContentException e) {
                DefaultElement defaultElement = e.getRootAsDefaultElement();
                persistentProjectSimulation = ProjectSimulationMigrator.migrate(defaultElement);
            }
            ProjectSimulation projectSimulation = project.getSimulations().createProjectSimulation(persistentProjectSimulation.getName());
            persistentProjectSimulation.addTo(projectSimulation);
            return projectSimulation;
        }
        catch (ParserException e) {
            throw ProjectException.wrap(e);
        }
    }

    public static void main(String[] args) {
        try {
            PersistentProjectSimulation persistentProjectSimulation = null;
            try {
                persistentProjectSimulation = PersistentProjectSimulation.parse(new File("C:\\Documents and Settings\\jorged\\Desktop\\OldSimulations\\FileSimulationProject2.xpsi"));
            }
            catch (UnexpectedContentException e) {
                DefaultElement defaultElement = e.getRootAsDefaultElement();
                persistentProjectSimulation = ProjectSimulationMigrator.migrate(defaultElement);
            }
            persistentProjectSimulation.store(new File("C:\\Documents and Settings\\jorged\\Desktop\\OldSimulations\\FileSimulationProject2-MIGRATED.xpsi"));
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTo(ProjectSimulation projectSimulation) {
        super.addTo(projectSimulation);
        projectSimulation.setUseCalendarRules(this.getUseCalendarRules());
        projectSimulation.setStartTime(Time.valueOf(this.getStartTime()));
        projectSimulation.setInflightFinish(this.getInflightFinish());
        try {
            projectSimulation.setDuration(Interval.valueOf(this.getDuration()));
        }
        catch (NumberFormatException e) {
            projectSimulation.setDuration(Interval.ONE_HOUR);
        }
    }
}

