/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.project;

import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.simulation.project.PersistentBaseModelSimulation;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.util.FileUtils;

public class PersistentModelSimulation
extends PersistentBaseModelSimulation {
    @Override
    public void addTo(ProjectSimulation projectSimulation) {
        Process process = projectSimulation.getProject().findProcess(this.getFormattedModelId());
        if (process != null) {
            Project project = process.getProject();
            ModelSimulation modelSimulation = project.getSimulations().findModelSimulation(process, this.getModelSimulationId());
            if (modelSimulation != null) {
                try {
                    projectSimulation.addModelSimulation(modelSimulation);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            } else {
                Log.logWarning(ProjectMsg.SIMULATION_MODEL_NOT_PRESENT);
            }
        }
    }

    private String getFormattedModelId() {
        return FileUtils.removeExtension((String)this.getModelId()).replace("/", "");
    }
}

