/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.migrator;

import oracle.bpm.project.io.serializers.simulation.model.PersistentActivities;
import oracle.bpm.project.io.serializers.simulation.model.PersistentActivity;
import oracle.bpm.project.io.serializers.simulation.model.PersistentConstantDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentExponentialDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentModelSimulation;
import oracle.bpm.project.io.serializers.simulation.model.PersistentNormalDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentTransition;
import oracle.bpm.project.io.serializers.simulation.model.PersistentTransitions;
import oracle.bpm.project.io.serializers.simulation.model.PersistentUniformDistribution;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.Element;

public class ModelSimulationMigrator {
    private ModelSimulationMigrator() {
    }

    public static PersistentModelSimulation migrate(DefaultElement rootElement) {
        PersistentModelSimulation persistentModelSimulation = new PersistentModelSimulation();
        if (rootElement.getNamespace() != null && rootElement.getNamespace().equals("")) {
            OldModelSimulationMigrationPolicy.migrate(rootElement, persistentModelSimulation);
        }
        return persistentModelSimulation;
    }

    private static class OldModelSimulationMigrationPolicy {
        private static final String SIMULATION_MODEL_TAG_NAME = "simulationmodel";
        private static final String ACTIVITY_TAG_NAME = "activity";
        private static final String TRANSITION_TAG_NAME = "transition";
        private static final String NORMAL_DISTRIBUTION_TAG_NAME = "normaldistribution";
        private static final String CONSTANT_DISTRIBUTION_TAG_NAME = "constantdistribution";
        private static final String UNIFORM_DISTRIBUTION_TAG_NAME = "uniformdistribution";
        private static final String EXPONENTIAL_DISTRIBUTION_TAG_NAME = "exponentialdistribution";

        private OldModelSimulationMigrationPolicy() {
        }

        public static void migrate(DefaultElement rootElement, PersistentModelSimulation persistentModelSimulation) {
            DefaultElement[] elements;
            OldModelSimulationMigrationPolicy.migrateElement(rootElement, persistentModelSimulation);
            for (DefaultElement element : elements = rootElement.findChildrenByClass(DefaultElement.class)) {
                OldModelSimulationMigrationPolicy.migrateElement(element, persistentModelSimulation);
            }
        }

        private static void migrateElement(DefaultElement element, PersistentModelSimulation persistentModelSimulation) {
            String tagName = element.getTagName().toLowerCase();
            if (tagName.equals(SIMULATION_MODEL_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateProcessSimulationModel(element, persistentModelSimulation);
            } else if (tagName.equals(ACTIVITY_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateActivity(element, persistentModelSimulation);
            } else if (tagName.equals(TRANSITION_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateTransition(element, persistentModelSimulation);
            } else if (tagName.equals(NORMAL_DISTRIBUTION_TAG_NAME) || tagName.equals(CONSTANT_DISTRIBUTION_TAG_NAME) || tagName.equals(UNIFORM_DISTRIBUTION_TAG_NAME) || tagName.equals(EXPONENTIAL_DISTRIBUTION_TAG_NAME)) {
                PersistentDistribution distribution = persistentModelSimulation.getDistribution();
                if (distribution == null) {
                    distribution = new PersistentDistribution();
                    persistentModelSimulation.addChild((Element)distribution);
                }
                OldModelSimulationMigrationPolicy.migrateDistribution(element, distribution);
            }
        }

        private static void migrateProcessSimulationModel(DefaultElement element, PersistentModelSimulation persistentModelSimulation) {
            persistentModelSimulation.setAttributes(element.getAttributes());
        }

        private static void migrateActivity(DefaultElement element, PersistentModelSimulation persistentModelSimulation) {
            PersistentActivities persistentActivities = persistentModelSimulation.getActivities();
            if (persistentActivities == null) {
                persistentActivities = new PersistentActivities();
                persistentModelSimulation.addChild((Element)persistentActivities);
            }
            PersistentActivity persistentActivity = new PersistentActivity();
            persistentActivity.setQueueWarningLevel(element.getIntAttribute("queueWarningLevel"));
            persistentActivity.setQueuePolicy(element.getAttribute("queuePolicy"));
            persistentActivity.setActivityCostType(element.getAttribute("activityCostType"));
            persistentActivity.setParticipantSelectionPolicy(element.getAttribute("participantSelectionPolicy"));
            persistentActivity.setName(element.getAttribute("name"));
            persistentActivity.setExceptionProbability(element.getDoubleAttribute("exceptionProbability"));
            persistentActivity.setAbortProbability(element.getDoubleAttribute("abortProbability"));
            persistentActivity.setCost(element.getDoubleAttribute("cost"));
            persistentActivity.setUseOrgResources(element.getBooleanAttribute("useOrgResources"));
            persistentActivity.setCapacity(element.getIntAttribute("capacity"));
            persistentActivity.setInnerSimulation(element.getBooleanAttribute("innerSimulation"));
            DefaultElement distributionElement = element.getFirstElement();
            if (distributionElement != null && OldModelSimulationMigrationPolicy.isADistributionElement(element.getFirstElement())) {
                PersistentDistribution distribution = persistentActivity.getDistribution();
                if (distribution == null) {
                    distribution = new PersistentDistribution();
                    persistentActivity.addChild((Element)distribution);
                }
                OldModelSimulationMigrationPolicy.migrateDistribution(distributionElement, distribution);
            }
            persistentActivities.addChild((Element)persistentActivity);
        }

        private static void migrateDistribution(DefaultElement distributionElement, DefaultElement destinationElement) {
            String name = distributionElement.getTagName().toLowerCase();
            if (name.equals(NORMAL_DISTRIBUTION_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateNormalDistribution(distributionElement, destinationElement);
            } else if (name.equals(CONSTANT_DISTRIBUTION_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateConstantDistribution(distributionElement, destinationElement);
            } else if (name.equals(UNIFORM_DISTRIBUTION_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateUniformDistribution(distributionElement, destinationElement);
            } else if (name.equals(EXPONENTIAL_DISTRIBUTION_TAG_NAME)) {
                OldModelSimulationMigrationPolicy.migrateExponentialDistribution(distributionElement, destinationElement);
            }
        }

        private static void migrateNormalDistribution(DefaultElement distributionElement, DefaultElement destinationElement) {
            PersistentNormalDistribution normalDistribution = new PersistentNormalDistribution();
            Long mean = distributionElement.getLongAttribute("mean");
            Long deviation = distributionElement.getLongAttribute("deviationPercentage");
            normalDistribution.setMean(mean);
            normalDistribution.setDeviation(mean * deviation / 100L);
            destinationElement.addChild((Element)normalDistribution);
        }

        private static void migrateConstantDistribution(DefaultElement distributionElement, DefaultElement destinationElement) {
            PersistentConstantDistribution constantDistribution = new PersistentConstantDistribution();
            constantDistribution.setPeriod(distributionElement.getLongAttribute("period"));
            destinationElement.addChild((Element)constantDistribution);
        }

        private static void migrateUniformDistribution(DefaultElement distributionElement, DefaultElement destinationElement) {
            PersistentUniformDistribution uniformDistribution = new PersistentUniformDistribution();
            Long deviation = distributionElement.getLongAttribute("deviationPercentage");
            Long avg = distributionElement.getLongAttribute("avg");
            uniformDistribution.setAvg(avg);
            uniformDistribution.setDeviation(avg * deviation / 100L);
            destinationElement.addChild((Element)uniformDistribution);
        }

        private static void migrateExponentialDistribution(DefaultElement distributionElement, DefaultElement destinationElement) {
            PersistentExponentialDistribution exponentialDistribution = new PersistentExponentialDistribution();
            exponentialDistribution.setEvents(distributionElement.getIntAttribute("events"));
            exponentialDistribution.setIntervalValue(distributionElement.getAttribute("intervalValue"));
            destinationElement.addChild((Element)exponentialDistribution);
        }

        private static boolean isADistributionElement(DefaultElement element) {
            String name = element.getTagName();
            return name.equals(NORMAL_DISTRIBUTION_TAG_NAME) || name.equals(CONSTANT_DISTRIBUTION_TAG_NAME) || name.equals(UNIFORM_DISTRIBUTION_TAG_NAME) || name.equals(EXPONENTIAL_DISTRIBUTION_TAG_NAME);
        }

        private static void migrateTransition(DefaultElement element, PersistentModelSimulation persistentModelSimulation) {
            PersistentTransitions persistentTransitions = persistentModelSimulation.getTransitions();
            if (persistentTransitions == null) {
                persistentTransitions = new PersistentTransitions();
                persistentModelSimulation.addChild((Element)persistentTransitions);
            }
            PersistentTransition persistentTransition = new PersistentTransition();
            persistentTransition.setName(element.getAttribute("name"));
            persistentTransition.setProbability(element.getDoubleAttribute("probability"));
            persistentTransitions.addChild((Element)persistentTransition);
        }
    }
}

