/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation;

import fuego.simulation.ConstantDistribution;
import fuego.simulation.ExponentialDistribution;
import fuego.simulation.NormalDistribution;
import fuego.simulation.RealDistribution;
import fuego.simulation.UniformDistribution;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.io.serializers.simulation.model.PersistentAbstractDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentActivities;
import oracle.bpm.project.io.serializers.simulation.model.PersistentActivity;
import oracle.bpm.project.io.serializers.simulation.model.PersistentCalculatedDistributions;
import oracle.bpm.project.io.serializers.simulation.model.PersistentConstantDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentExponentialDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentModelSimulation;
import oracle.bpm.project.io.serializers.simulation.model.PersistentNormalDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentRealDistribution;
import oracle.bpm.project.io.serializers.simulation.model.PersistentTransition;
import oracle.bpm.project.io.serializers.simulation.model.PersistentTransitions;
import oracle.bpm.project.io.serializers.simulation.model.PersistentUniformDistribution;
import oracle.bpm.project.model.ProjectVisitorAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.xmlparser.Element;

public class ModelSimulationVisitor
extends ProjectVisitorAdapter {
    private PersistentModelSimulation persistentModelSimulation = new PersistentModelSimulation();

    public PersistentModelSimulation getPersistentModelSimulation() {
        return this.persistentModelSimulation;
    }

    @Override
    public void visit(ModelSimulation modelSimulation) throws ProjectException {
        this.persistentModelSimulation.setName(modelSimulation.getId());
        this.persistentModelSimulation.setProcessVariation("");
        this.persistentModelSimulation.setProcessPath(this.createModelSimulationPath(modelSimulation));
        this.persistentModelSimulation.setMaxInstances(modelSimulation.getMaxInstances());
        this.persistentModelSimulation.setUseMaxInstances(modelSimulation.getUseMaxInstances());
        this.visitActivities(modelSimulation);
        this.visitTransitions(modelSimulation);
        this.visitDistributions(modelSimulation);
        this.visitCalculedDistributions(modelSimulation);
    }

    @Override
    public void visit(SimulationSequenceFlow simulationSequenceFlow) throws ProjectException {
        PersistentTransitions persistentTransitions = this.persistentModelSimulation.getTransitions();
        PersistentTransition persistentTransition = new PersistentTransition();
        persistentTransition.setName(simulationSequenceFlow.getId());
        persistentTransition.setProbability(simulationSequenceFlow.getProbability());
        Interval interval = simulationSequenceFlow.getDueInterval();
        if (interval != null) {
            persistentTransition.setDueInterval(interval.toXMLString());
        }
        persistentTransitions.addChild((Element)persistentTransition);
    }

    @Override
    public void visit(SimulationFlowNode simulationActivity) throws ProjectException {
        PersistentActivities persistentSimulationActivities = this.persistentModelSimulation.getActivities();
        PersistentActivity persistentActivity = new PersistentActivity();
        persistentActivity.setQueueWarningLevel(simulationActivity.getQueueWarningLevel());
        persistentActivity.setQueuePolicy(simulationActivity.getQueuePolicy().toString());
        persistentActivity.setActivityCostType(simulationActivity.getActivityCostType().toString());
        persistentActivity.setParticipantSelectionPolicy(simulationActivity.getParticipantSelectionPolicy().toString());
        persistentActivity.setName(simulationActivity.getId());
        persistentActivity.setExceptionProbability(simulationActivity.getExceptionProbability());
        persistentActivity.setAbortProbability(simulationActivity.getAbortProbability());
        persistentActivity.setCost(simulationActivity.getCost());
        persistentActivity.setUseOrgResources(simulationActivity.getUseOrgResources());
        persistentActivity.setCapacity(simulationActivity.getCapacity());
        persistentActivity.setInnerSimulation(simulationActivity.getInnerSimulation());
        PersistentDistribution persistentDistribution = new PersistentDistribution();
        PersistentAbstractDistribution abstractDistribution = this.generateDistributionData(simulationActivity.getDistribution());
        persistentDistribution.setPersistentAbstractDistribution(abstractDistribution);
        persistentActivity.setDistribution(persistentDistribution);
        if (simulationActivity.getCalculatedDistributions() != null && simulationActivity.getCalculatedDistributions().length > 0) {
            PersistentCalculatedDistributions persistentCalculatedDistribution = new PersistentCalculatedDistributions();
            for (Distribution distribution : simulationActivity.getCalculatedDistributions()) {
                PersistentAbstractDistribution abstractCalculatedDistribution = this.generateDistributionData(distribution);
                persistentCalculatedDistribution.setPersistentAbstractDistribution(abstractCalculatedDistribution);
            }
            persistentActivity.setCalculatedDistributions(persistentCalculatedDistribution);
        }
        persistentSimulationActivities.addChild((Element)persistentActivity);
    }

    private void visitDistributions(ModelSimulation modelSimulation) {
        PersistentDistribution persistentDistribution = new PersistentDistribution();
        PersistentAbstractDistribution abstractDistribution = this.generateDistributionData(modelSimulation.getDistributions()[0]);
        persistentDistribution.setPersistentAbstractDistribution(abstractDistribution);
        this.persistentModelSimulation.setDistribution(persistentDistribution);
    }

    private void visitCalculedDistributions(ModelSimulation modelSimulation) {
        PersistentCalculatedDistributions persistentDistribution = new PersistentCalculatedDistributions();
        if (modelSimulation.getCalculatedDistributions() != null) {
            for (Distribution distribution : modelSimulation.getCalculatedDistributions()) {
                PersistentAbstractDistribution abstractDistribution = this.generateDistributionData(distribution);
                persistentDistribution.setPersistentAbstractDistribution(abstractDistribution);
            }
            this.persistentModelSimulation.setCalculatedDistributions(persistentDistribution);
        }
    }

    private void visitTransitions(ModelSimulation modelSimulation) throws ProjectException {
        PersistentTransitions persistentTransitions = this.persistentModelSimulation.getTransitions();
        if (persistentTransitions == null) {
            this.persistentModelSimulation.setTransitions(new PersistentTransitions());
        }
        for (SimulationSequenceFlow simulationSequenceFlow : modelSimulation.getSimulationSequenceFlows()) {
            simulationSequenceFlow.visit(this);
        }
    }

    private void visitActivities(ModelSimulation modelSimulation) throws ProjectException {
        PersistentActivities persistentActivities = this.persistentModelSimulation.getActivities();
        if (persistentActivities == null) {
            this.persistentModelSimulation.setActivities(new PersistentActivities());
        }
        for (SimulationFlowNode simulationActivity : modelSimulation.getSimulationFlowNodes()) {
            simulationActivity.visit(this);
        }
    }

    private String createModelSimulationPath(ModelSimulation modelSimulation) {
        return "/" + modelSimulation.getProcess().getId() + ".xpdl";
    }

    private PersistentAbstractDistribution generateDistributionData(Distribution distribution) {
        if (distribution.getType() == DistributionType.CONSTANT) {
            ConstantDistribution constantDistribution = (ConstantDistribution)distribution;
            PersistentConstantDistribution persistentConstantDistribution = new PersistentConstantDistribution();
            persistentConstantDistribution.setPeriod(constantDistribution.getPeriod());
            return persistentConstantDistribution;
        }
        if (distribution.getType() == DistributionType.EXPONENTIAL) {
            ExponentialDistribution exponentialDistribution = (ExponentialDistribution)distribution;
            PersistentExponentialDistribution persistentExponentialDistribution = new PersistentExponentialDistribution();
            persistentExponentialDistribution.setEvents(exponentialDistribution.getEvents());
            persistentExponentialDistribution.setIntervalValue(exponentialDistribution.getIntervalValue());
            return persistentExponentialDistribution;
        }
        if (distribution.getType() == DistributionType.NORMAL) {
            NormalDistribution normalDistribution = (NormalDistribution)distribution;
            PersistentNormalDistribution persistentNormalDistribution = new PersistentNormalDistribution();
            persistentNormalDistribution.setDeviation(normalDistribution.getDeviation());
            persistentNormalDistribution.setMean(normalDistribution.getMean());
            return persistentNormalDistribution;
        }
        if (distribution.getType() == DistributionType.UNIFORM) {
            UniformDistribution uniformDistribution = (UniformDistribution)distribution;
            PersistentUniformDistribution persistentUniformDistribution = new PersistentUniformDistribution();
            persistentUniformDistribution.setAvg(uniformDistribution.getAvg());
            persistentUniformDistribution.setDeviation(uniformDistribution.getDeviation());
            return persistentUniformDistribution;
        }
        if (distribution.getType() == DistributionType.REAL) {
            RealDistribution realDistribution = (RealDistribution)distribution;
            PersistentRealDistribution persistentRealDistribution = new PersistentRealDistribution();
            persistentRealDistribution.setRealDistributionSubtype(realDistribution.getRealDistributionCriteria().name());
            for (int i = 0; i < realDistribution.groupsSize(); ++i) {
                Distribution subDistribution = realDistribution.getDistribution(i);
                PersistentAbstractDistribution abstractDistribution = this.generateDistributionData(subDistribution);
                persistentRealDistribution.addChild((Element)abstractDistribution);
            }
            return persistentRealDistribution;
        }
        assert (false) : "unknow DistributionType";
        return null;
    }
}

