/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.xml.XmlWriter;

public class XmlRoleSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        Collection<CalendarRuleAssignment> calendarRules;
        Collection<String> parametricValues;
        assert (object instanceof Role);
        Role role = (Role)object;
        xmlWriter.startElement("DirOrganizationalRole");
        xmlWriter.printValuedElement("name", role.getId());
        xmlWriter.printValuedElement("description", role.getDescription());
        LocaleStringMap labelMap = role.getLabelMap();
        if (!labelMap.isEmpty()) {
            xmlWriter.startElement("localizedDisplayNames");
            for (Map.Entry<Locale, String> entry : labelMap) {
                xmlWriter.startElement("localizedDisplayName");
                xmlWriter.printValuedElement("locale", entry.getKey().toString());
                xmlWriter.printValuedElement("message", entry.getValue());
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.printValuedElement("isParametric", String.valueOf(role.isParametric()));
        if (role.isParametric() && !(parametricValues = role.getParametricValues()).isEmpty()) {
            xmlWriter.startElement("parametricValues");
            for (String parametricValue : parametricValues) {
                xmlWriter.printValuedElement("value", parametricValue);
            }
            xmlWriter.endElement();
        }
        if (!(calendarRules = role.getCalendarRuleAssignment()).isEmpty()) {
            xmlWriter.startElement("calendarRules");
            for (CalendarRuleAssignment calendarRuleAssignment : calendarRules) {
                if (calendarRuleAssignment.getCalendarRule() == null) continue;
                xmlWriter.startElement("calendarRule");
                xmlWriter.printValuedElement("nameCalendar", calendarRuleAssignment.getCalendarRule().getId());
                xmlWriter.printValuedElement("ou", calendarRuleAssignment.getOrganizationalUnit() != null ? calendarRuleAssignment.getOrganizationalUnit().getId() : null);
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }
}

