/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import java.io.Writer;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.io.DirPresentationWriter;
import oracle.bpm.xml.XmlWriter;

public class XmlPresentationSerializer
extends BaseXmlSerializer {
    @Override
    public void write(Writer writer, ProjectObject object) throws ProjectException {
        assert (object instanceof Presentation);
        Presentation presentation = (Presentation)object;
        object.getProject().getPresentationManager().storePresentation(presentation, writer);
    }

    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof Presentation);
        Presentation presentation = (Presentation)object;
        DirPresentationWriter.write((PresentationImpl)presentation.getPresentationImpl(), (XmlWriter)xmlWriter);
    }
}

