/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.xml.XmlWriter;

public class XmlGroupSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof Group);
        Group group = (Group)object;
        xmlWriter.startElement("DirOrganizationalGroup");
        xmlWriter.printValuedElement("name", group.getId());
        xmlWriter.printValuedElement("description", group.getDescription());
        xmlWriter.printValuedElement("status", this.getStatus(group.isEnabled()));
        xmlWriter.printValuedElement("allowRolesAssigned", Boolean.toString(true));
        this.writeRoleAssignments(group, xmlWriter);
        this.writeGroupAssigments(group, xmlWriter);
        Collection<GroupAssignment> assignedObjects = group.getAssignedObjects();
        ArrayList<GroupAssignment> assignedGroups = new ArrayList<GroupAssignment>();
        ArrayList<GroupAssignment> assignedParticipants = new ArrayList<GroupAssignment>();
        for (GroupAssignment groupAssignment : assignedObjects) {
            if (groupAssignment.getAssignedObject() instanceof Group) {
                assignedGroups.add(groupAssignment);
                continue;
            }
            assert (groupAssignment.getAssignedObject() instanceof Participant);
            assignedParticipants.add(groupAssignment);
        }
        if (!assignedGroups.isEmpty()) {
            xmlWriter.startElement("assignedGroups");
            for (GroupAssignment assignment : assignedGroups) {
                xmlWriter.printValuedElement("groupId", assignment.getAssignedObject().getId());
            }
            xmlWriter.endElement();
        }
        if (!assignedParticipants.isEmpty()) {
            xmlWriter.startElement("assignedParticipants");
            for (GroupAssignment assignment : assignedParticipants) {
                xmlWriter.printValuedElement("participantId", assignment.getAssignedObject().getId());
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void writeRoleAssignments(Group group, XmlWriter xmlWriter) throws IOException {
        Collection<RoleAssignment> roleAssignments = group.getRoleAssignments();
        if (!roleAssignments.isEmpty()) {
            xmlWriter.startElement("rolesAssignment");
            for (RoleAssignment roleAssignment : roleAssignments) {
                xmlWriter.startElement("roleAssignment");
                xmlWriter.printValuedElement("roleId", roleAssignment.getRole() != null ? roleAssignment.getRole().getId() : roleAssignment.getRoleId());
                xmlWriter.printValuedElement("parametricValue", roleAssignment.getParametricValue());
                xmlWriter.printValuedElement("permissions", String.valueOf(roleAssignment.getPermissions()));
                xmlWriter.printValuedElement("category", String.valueOf(roleAssignment.getCategory()));
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
    }

    private void writeGroupAssigments(Group group, XmlWriter xmlWriter) throws IOException {
        Collection<GroupAssignment> groupAssignments = group.getGroupAssignments(group);
        if (!groupAssignments.isEmpty()) {
            xmlWriter.startElement("assignedGroups");
            for (GroupAssignment groupAssignment : groupAssignments) {
                xmlWriter.printValuedElement("groupId", groupAssignment.getGroup() != null ? groupAssignment.getGroup().getId() : groupAssignment.getGroupId());
            }
            xmlWriter.endElement();
        }
    }

    private String getStatus(boolean enabled) {
        return enabled ? "A" : "D";
    }
}

