/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.HashMap;
import oracle.bpm.project.io.exception.CheckContentTypeException;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObjectType;
import org.xml.sax.SAXException;

public class PropertiesHandler
extends BaseSourceHandler {
    private HashMap<String, HashMap> propertiesByCategory;

    public PropertiesHandler(BaseSourceHandler parent, HashMap<String, HashMap> propertiesByCategory, boolean checkContentType) {
        super(parent, checkContentType);
        this.propertiesByCategory = propertiesByCategory;
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if (name.endsWith("Property")) {
            return new PropertyHandler(this, this.isCheckContentType());
        }
        return new BaseSourceHandler(this);
    }

    private class PropertyHandler
    extends BaseSourceHandler {
        private String category;
        private String key;
        private String value;

        public PropertyHandler(BaseSourceHandler parent, boolean checkContentType) {
            super(parent, checkContentType);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("prop_category".equals(name)) {
                return new PropertyCategoryHandler(this);
            }
            if ("prop_key".equals(name)) {
                return new PropertyKeyHandler(this);
            }
            if ("prop_value".equals(name)) {
                return new PropertyValueHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            HashMap<String, String> properties = (HashMap<String, String>)PropertiesHandler.this.propertiesByCategory.get(this.category);
            if (properties == null) {
                properties = new HashMap<String, String>();
                PropertiesHandler.this.propertiesByCategory.put(this.category, properties);
            }
            properties.put(this.key, this.value);
            if (this.isCheckContentType() && PropertiesHandler.this.propertiesByCategory.keySet().contains("PROFILE_CATEGORY")) {
                throw new CheckContentTypeException(ProjectObjectType.PARTICIPANT);
            }
        }

        private class PropertyValueHandler
        extends DataElementHandler {
            public PropertyValueHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                PropertyHandler.this.value = this.getData();
            }
        }

        private class PropertyKeyHandler
        extends DataElementHandler {
            public PropertyKeyHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                PropertyHandler.this.key = this.getData();
            }
        }

        private class PropertyCategoryHandler
        extends DataElementHandler {
            public PropertyCategoryHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                PropertyHandler.this.category = this.getData();
            }
        }
    }
}

