/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.LinkedHashMap;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.io.serializers.ProjectPreferencesXMLGenerator;
import oracle.bpm.project.io.serializers.layout.XmlLayoutSerializer;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.io.serializers.organization.XmlBusinessParameterSerializer;
import oracle.bpm.project.io.serializers.organization.XmlCalendarRuleSerializer;
import oracle.bpm.project.io.serializers.organization.XmlGroupSerializer;
import oracle.bpm.project.io.serializers.organization.XmlHolidayRuleSerializer;
import oracle.bpm.project.io.serializers.organization.XmlOrganizationSerializer;
import oracle.bpm.project.io.serializers.organization.XmlOrganizationalChartSerializer;
import oracle.bpm.project.io.serializers.organization.XmlOrganizationalUnitSerializer;
import oracle.bpm.project.io.serializers.organization.XmlParticipantSerializer;
import oracle.bpm.project.io.serializers.organization.XmlPresentationSerializer;
import oracle.bpm.project.io.serializers.organization.XmlReferralSerializer;
import oracle.bpm.project.io.serializers.organization.XmlRoleSerializer;
import oracle.bpm.project.io.serializers.organization.XmlTopologySerializer;
import oracle.bpm.project.io.serializers.organization.view.XmlViewSerializer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.deployment.Referral;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.layouts.Layout;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.variables.BusinessParameter;

public class ProjectObjectSerializerFactory {
    public static final LinkedHashMap<Class, ProjectObjectSerializer> registry = new LinkedHashMap();

    public static ProjectObjectSerializer getSerializer(ProjectObject object) {
        for (Class key : registry.keySet()) {
            if (!key.isAssignableFrom(object.getClass())) continue;
            return registry.get(key);
        }
        throw new ProgramException("There are no serializer registered for the ProjectObject of type '" + object.getClass().getName() + "\nObject: " + object);
    }

    static {
        registry.put(Role.class, new XmlRoleSerializer());
        registry.put(Participant.class, new XmlParticipantSerializer());
        registry.put(OrganizationalUnit.class, new XmlOrganizationalUnitSerializer());
        registry.put(Group.class, new XmlGroupSerializer());
        registry.put(CalendarRule.class, new XmlCalendarRuleSerializer());
        registry.put(HolidayRule.class, new XmlHolidayRuleSerializer());
        registry.put(BusinessParameter.class, new XmlBusinessParameterSerializer());
        registry.put(Presentation.class, new XmlPresentationSerializer());
        registry.put(Topology.class, new XmlTopologySerializer());
        registry.put(Referral.class, new XmlReferralSerializer());
        registry.put(View.class, new XmlViewSerializer());
        registry.put(Organization.class, new XmlOrganizationSerializer());
        registry.put(Layout.class, new XmlLayoutSerializer());
        registry.put(ProjectPreferences.class, new ProjectPreferencesXMLGenerator());
        registry.put(OrganizationalChart.class, new XmlOrganizationalChartSerializer());
    }
}

