/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import oracle.bpm.lang.Time;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.RoleAssignmentHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.util.Locales;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ParticipantHandler
extends BaseSourceHandler {
    protected double cost;
    protected int efficiency;
    protected Collection<RoleAssignmentHandler.RoleAssignmentData> roleAssignments = new ArrayList<RoleAssignmentHandler.RoleAssignmentData>();
    private Collection<ParticipantAbsenceHandler.ParticipantAbsenceData> absences;
    private Collection<String> assignedGroups = new ArrayList<String>();
    private String displayName;
    private String employeeId;
    private String fax;
    private String firstName;
    private String id;
    private String lastName;
    private String locale;
    private String mail;
    private String manager;
    private String ou;
    private boolean receivesMail;
    private String status;
    private String telephone;
    private String timezone;

    ParticipantHandler(BaseSourceHandler parent) {
        super(parent);
        this.absences = new ArrayList<ParticipantAbsenceHandler.ParticipantAbsenceData>();
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("id".equals(name)) {
            return new IdHandler(this);
        }
        if ("firstName".equals(name)) {
            return new FirstNameHandler(this);
        }
        if ("lastName".equals(name)) {
            return new LastNameHandler(this);
        }
        if ("displayName".equals(name)) {
            return new DisplayNameHandler(this);
        }
        if ("mail".equals(name)) {
            return new MailHandler(this);
        }
        if ("receivesMail".equals(name)) {
            return new ReceivesMailHandler(this);
        }
        if ("ou".equals(name)) {
            return new OUHandler(this);
        }
        if ("status".equals(name)) {
            return new StatusHandler(this);
        }
        if ("telephone".equals(name)) {
            return new TelephoneHandler(this);
        }
        if ("fax".equals(name)) {
            return new FaxHandler(this);
        }
        if ("locale".equals(name)) {
            return new LocaleHandler(this);
        }
        if ("timezone".equals(name)) {
            return new TimeZoneHandler(this);
        }
        if ("employeeId".equals(name)) {
            return new EmployeeIdHandler(this);
        }
        if ("manager".equals(name)) {
            return new ManagerHandler(this);
        }
        if ("rolesAssignment".equals(name)) {
            return new AssignedRolesHandler(this);
        }
        if ("assignedGroups".equals(name)) {
            return new AssignedGroupsHandler(this);
        }
        if ("absences".equals(name)) {
            return new AbsencesHandler(this);
        }
        if ("cost".equals(name)) {
            return new CostHandler(this);
        }
        if ("efficiency".equals(name)) {
            return new EfficiencyHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ResourceContainer container = this.getContainer();
            Participant p = container.createParticipant(this.id);
            Participant.Mutable participant = p.asMutable();
            participant.setDisplayName(this.displayName);
            participant.setEmployeeId(this.employeeId);
            participant.setFax(this.fax);
            participant.setFirstName(this.firstName);
            participant.setLastName(this.lastName);
            participant.setMail(this.mail);
            participant.setManager(this.manager);
            participant.setReceivesMail(this.receivesMail);
            participant.setTelephone(this.telephone);
            participant.setLocale(this.locale != null ? Locales.valueOf(this.locale) : null);
            participant.setTimeZone(this.timezone != null ? TimeZone.getTimeZone(this.timezone) : null);
            participant.setCost(this.cost);
            participant.setEfficiency(this.efficiency);
            if ("S".equals(this.status)) {
                participant.setAdministrator(true);
            } else if ("A".equals(this.status)) {
                participant.setEnabled(true);
            } else if ("D".equals(this.status)) {
                participant.setEnabled(false);
            } else assert (false) : "Invalid status for participant! Value: " + this.status;
            participant.setOrganizationalUnitId(this.ou);
            for (RoleAssignmentHandler.RoleAssignmentData roleAssignmentData : this.roleAssignments) {
                RoleAssignment.Mutable roleAssignment = participant.createRoleAssignment();
                roleAssignment.setCategory(roleAssignmentData.category);
                roleAssignment.setParametricValue(roleAssignmentData.parametricValue);
                roleAssignment.setPermissions(roleAssignmentData.permissions);
                roleAssignment.setRole(roleAssignmentData.roleId);
                participant.addRoleAssignment(roleAssignment);
            }
            for (String groupId : this.assignedGroups) {
                GroupAssignment.Mutable groupAssignment = participant.asMutable().createGroupAssignment();
                groupAssignment.setGroupId(groupId);
                participant.addGroupAssignment(groupAssignment);
            }
            this.getParseListener().objectParsed(this, participant);
        }
        catch (ProjectException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private class TimeZoneHandler
    extends DataElementHandler {
        public TimeZoneHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.timezone = this.getData();
        }
    }

    private class TelephoneHandler
    extends DataElementHandler {
        public TelephoneHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.telephone = this.getData();
        }
    }

    private class StatusHandler
    extends DataElementHandler {
        public StatusHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.status = this.getData();
        }
    }

    private class ReceivesMailHandler
    extends DataElementHandler {
        public ReceivesMailHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.receivesMail = Boolean.valueOf(this.getData());
        }
    }

    private class ParticipantAbsenceHandler
    extends BaseSourceHandler {
        ParticipantAbsenceData absence;

        public ParticipantAbsenceHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.absence = new ParticipantAbsenceData();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.absences.add(this.absence);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("from".equals(name)) {
                return new ParticipantAbsenceFromHandler(this);
            }
            if ("to".equals(name)) {
                return new ParticipantAbsenceToHandler(this);
            }
            if ("replacement".equals(name)) {
                return new ParticipantAbsenceReplacementHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class ParticipantAbsenceToHandler
        extends DataElementHandler {
            public ParticipantAbsenceToHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                ParticipantAbsenceHandler.this.absence.to = Time.valueOf(this.getData());
            }
        }

        private class ParticipantAbsenceReplacementHandler
        extends DataElementHandler {
            public ParticipantAbsenceReplacementHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                ParticipantAbsenceHandler.this.absence.replacements.add(this.getData());
            }
        }

        private class ParticipantAbsenceFromHandler
        extends DataElementHandler {
            public ParticipantAbsenceFromHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                ParticipantAbsenceHandler.this.absence.from = Time.valueOf(this.getData());
            }
        }

        private class ParticipantAbsenceData {
            Time from;
            Collection<String> replacements = new ArrayList<String>();
            Time to;

            ParticipantAbsenceData() {
            }
        }
    }

    private class OUHandler
    extends DataElementHandler {
        public OUHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.ou = this.getData();
        }
    }

    private class ManagerHandler
    extends DataElementHandler {
        public ManagerHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.manager = this.getData();
        }
    }

    private class MailHandler
    extends DataElementHandler {
        public MailHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.mail = this.getData();
        }
    }

    private class LocaleHandler
    extends DataElementHandler {
        public LocaleHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.locale = this.getData();
        }
    }

    private class LastNameHandler
    extends DataElementHandler {
        public LastNameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.lastName = this.getData();
        }
    }

    private class IdHandler
    extends DataElementHandler {
        public IdHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.id = this.getData();
        }
    }

    private class FirstNameHandler
    extends DataElementHandler {
        public FirstNameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.firstName = this.getData();
        }
    }

    private class FaxHandler
    extends DataElementHandler {
        public FaxHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.fax = this.getData();
        }
    }

    private class EmployeeIdHandler
    extends DataElementHandler {
        public EmployeeIdHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.employeeId = this.getData();
        }
    }

    private class EfficiencyHandler
    extends DataElementHandler {
        public EfficiencyHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.efficiency = Integer.valueOf(this.getData());
        }
    }

    private class DisplayNameHandler
    extends DataElementHandler {
        public DisplayNameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.displayName = this.getData();
        }
    }

    private class CostHandler
    extends DataElementHandler {
        public CostHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParticipantHandler.this.cost = Double.valueOf(this.getData());
        }
    }

    private class AssignedRolesHandler
    extends BaseSourceHandler {
        public AssignedRolesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("roleAssignment".equals(name)) {
                return new RoleAssignmentHandler((BaseSourceHandler)this, ParticipantHandler.this.roleAssignments);
            }
            return new BaseSourceHandler(this);
        }
    }

    private class AssignedGroupsHandler
    extends BaseSourceHandler {
        public AssignedGroupsHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("groupId".equals(name)) {
                return new GroupAssignmentHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class GroupAssignmentHandler
        extends DataElementHandler {
            public GroupAssignmentHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                ParticipantHandler.this.assignedGroups.add(this.getData());
            }
        }
    }

    private class AbsencesHandler
    extends BaseSourceHandler {
        public AbsencesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("absence".equals(name)) {
                return new ParticipantAbsenceHandler(this);
            }
            return new BaseSourceHandler(this);
        }
    }
}

