/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import org.xml.sax.SAXException;

public class OrganizationalChartHandler
extends BaseSourceHandler {
    private Collection<OUData> chartOUs = new ArrayList<OUData>();
    private String id;

    OrganizationalChartHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("organizationalUnits".equals(name)) {
            return new OrganizationalUnitsHandler(this, null);
        }
        if ("name".equals(name)) {
            return new NameHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ResourceContainer container = this.getContainer();
            OrganizationalChart oc = container.createOrganizationalChart(null, this.id);
            for (OUData ouData : this.chartOUs) {
                OrganizationalUnit ou = this.createOU(ouData, null, oc);
                oc.getRootOrganizationalUnit().addChild(ou);
            }
            this.getParseListener().objectParsed(this, oc);
        }
        catch (ProjectException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private OrganizationalUnit createOU(OUData ouData, OrganizationalUnit parent, OrganizationalChart oc) throws ProjectException {
        OrganizationalUnit ou = oc.createOrganizationalUnit(ouData.name, parent);
        ou.asMutable().setDescription(ouData.description);
        if (ouData.calendarRuleName != null) {
            CalendarRuleAssignment.Mutable calendarRuleAssignment = ou.asMutable().createCalendarRuleAssignment();
            calendarRuleAssignment.setCalendarRule(ouData.calendarRuleName);
            ou.asMutable().addCalendarRuleAssignment(calendarRuleAssignment);
        }
        for (OUData child : ouData.children) {
            OrganizationalUnit childOu = this.createOU(child, ou, oc);
            ou.addChild(childOu);
        }
        return ou;
    }

    private class OUData {
        String calendarRuleName;
        Collection<OUData> children = new ArrayList<OUData>();
        String description;
        String name;

        private OUData() {
        }
    }

    private class OrganizationalUnitsHandler
    extends DataElementHandler {
        OUData parent;
        private Collection<OUData> ous;

        public OrganizationalUnitsHandler(BaseSourceHandler parentHandler, OUData parentOU) {
            super(parentHandler);
            this.ous = new ArrayList<OUData>();
            this.parent = parentOU;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.parent == null) {
                OrganizationalChartHandler.this.chartOUs = this.ous;
            } else {
                this.parent.children = this.ous;
            }
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("ou".equals(name)) {
                return new OrganizationalUnitHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        private class OrganizationalUnitHandler
        extends DataElementHandler {
            OUData ouData;

            public OrganizationalUnitHandler(BaseSourceHandler parent) {
                super(parent);
                this.ouData = new OUData();
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                OrganizationalUnitsHandler.this.ous.add(this.ouData);
            }

            @Override
            public SourceHandler getHandler(String uri, String qName, String name) {
                if ("name".equals(name)) {
                    return new OUNameHandler(this);
                }
                if ("description".equals(name)) {
                    return new OUDescriptionHandler(this);
                }
                if ("nameCalendar".equals(name)) {
                    return new OUCalendarRuleNameHandler(this);
                }
                if ("organizationalUnits".equals(name)) {
                    return new OrganizationalUnitsHandler(this, this.ouData);
                }
                return new BaseSourceHandler(this);
            }

            private class OUNameHandler
            extends DataElementHandler {
                public OUNameHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    OrganizationalUnitHandler.this.ouData.name = this.getData();
                }
            }

            private class OUDescriptionHandler
            extends DataElementHandler {
                public OUDescriptionHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    OrganizationalUnitHandler.this.ouData.description = this.getData();
                }
            }

            private class OUCalendarRuleNameHandler
            extends DataElementHandler {
                public OUCalendarRuleNameHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    OrganizationalUnitHandler.this.ouData.calendarRuleName = this.getData();
                }
            }
        }
    }

    private class NameHandler
    extends DataElementHandler {
        public NameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            OrganizationalChartHandler.this.id = this.getData();
        }
    }
}

