/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import oracle.bpm.project.io.exception.CheckContentTypeException;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.BusinessParameterHandler;
import oracle.bpm.project.io.serializers.organization.CalendarRuleHandler;
import oracle.bpm.project.io.serializers.organization.GroupHandler;
import oracle.bpm.project.io.serializers.organization.HolidayRuleHandler;
import oracle.bpm.project.io.serializers.organization.LayoutHandler;
import oracle.bpm.project.io.serializers.organization.OrganizationalChartHandler;
import oracle.bpm.project.io.serializers.organization.OrganizationalUnitHandler;
import oracle.bpm.project.io.serializers.organization.ParticipantHandler;
import oracle.bpm.project.io.serializers.organization.ProjectSourceHandler;
import oracle.bpm.project.io.serializers.organization.ReferralHandler;
import oracle.bpm.project.io.serializers.organization.RoleHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.io.serializers.organization.VariableHandler;
import oracle.bpm.project.model.ProjectObjectType;

class DirObjectHandler
extends BaseSourceHandler {
    DirObjectHandler(ProjectSourceHandler topHandler, boolean checkContentType) {
        super(topHandler, checkContentType);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("DirOrganizationalUnit".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.OU);
            }
            return new OrganizationalUnitHandler(this);
        }
        if ("layout".equals(name)) {
            return new LayoutHandler(this);
        }
        if ("DirOrganizationalRole".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.ORGANIZATION_ROLE);
            }
            return new RoleHandler(this);
        }
        if ("DirCalendarRule".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.CALENDAR_RULE);
            }
            return new CalendarRuleHandler(this);
        }
        if ("DirHolidayRule".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.HOLIDAY_RULE);
            }
            return new HolidayRuleHandler(this);
        }
        if ("DirOrganizationalGroup".equals(name)) {
            return new GroupHandler(this, this.isCheckContentType());
        }
        if ("DirHumanParticipant".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.PARTICIPANT);
            }
            return new ParticipantHandler(this);
        }
        if ("measuredParticipant".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.PARTICIPANT);
            }
            return new ParticipantHandler(this);
        }
        if ("DirProcessVariable".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.INSTANCE_VARIABLE);
            }
            return new VariableHandler(this);
        }
        if ("DirReferral".equals(name)) {
            return new ReferralHandler(this);
        }
        if ("DirBusinessParameter".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.BUSINESS_PARAMETER);
            }
            return new BusinessParameterHandler(this);
        }
        if ("OrganizationalChart".equals(name)) {
            if (this.isCheckContentType()) {
                throw new CheckContentTypeException(ProjectObjectType.ORGANIZATIONAL_CHART);
            }
            return new OrganizationalChartHandler(this);
        }
        return new BaseSourceHandler(this);
    }
}

