/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.model.variables.DefaultValueAssignment;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BusinessParameterHandler
extends BaseSourceHandler {
    private Object defaultValue;
    private String id;
    private String size;
    private String type;
    private HashMap<String, Object> values;

    BusinessParameterHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("id".equals(name)) {
            return new IdHandler(this);
        }
        if ("type".equals(name)) {
            return new TypeHandler(this);
        }
        if ("size".equals(name)) {
            return new SizeHandler(this);
        }
        if ("defaultValue".equals(name)) {
            return new DefaultValueHandler(this);
        }
        if ("valuesMap".equals(name)) {
            return new ValuesMapNamesHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ResourceContainer container = this.getContainer();
            BusinessParameter bp = container.createBusinessParameter(this.id);
            BusinessParameter.Mutable businessParameter = bp.asMutable();
            businessParameter.setTypeDescription(CatalogType.Default.get((TypeRef)TypeFactory.forNameNonPrimitive((String)this.type, (String)this.size)));
            businessParameter.setDefaultValue(this.defaultValue);
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                DefaultValueAssignment.Mutable assignment = businessParameter.createDefaultValueAssignment();
                assignment.setOrganizationalUnitId(entry.getKey());
                assignment.setDefaultValue(entry.getValue());
                businessParameter.asMutable().addDefaultValueAssignment(assignment);
            }
            this.getParseListener().objectParsed(this, bp);
        }
        catch (ProjectException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
    }

    private class ValuesMapNamesHandler
    extends BaseSourceHandler {
        public ValuesMapNamesHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public SourceHandler getHandler(String uri, String qName, String name) {
            if ("entry".equals(name)) {
                return new ValueEntryHandler(this);
            }
            return new BaseSourceHandler(this);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            BusinessParameterHandler.this.values = new HashMap();
        }

        private class ValueEntryHandler
        extends BaseSourceHandler {
            private String ou;
            private Object value;

            public ValueEntryHandler(BaseSourceHandler parent) {
                super(parent);
            }

            @Override
            public SourceHandler getHandler(String uri, String qName, String name) {
                if ("key".equals(name)) {
                    return new KeyHandler(this);
                }
                if ("value".equals(name)) {
                    return new ValueHandler(this);
                }
                return new BaseSourceHandler(this);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                BusinessParameterHandler.this.values.put(this.ou, this.value);
            }

            private class ValueHandler
            extends DataElementHandler {
                public ValueHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    ValueEntryHandler.this.value = this.getData();
                }
            }

            private class KeyHandler
            extends DataElementHandler {
                public KeyHandler(BaseSourceHandler parent) {
                    super(parent);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    ValueEntryHandler.this.ou = this.getData();
                }
            }
        }
    }

    private class TypeHandler
    extends DataElementHandler {
        public TypeHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            BusinessParameterHandler.this.type = this.getData();
        }
    }

    private class SizeHandler
    extends DataElementHandler {
        public SizeHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            BusinessParameterHandler.this.size = this.getData();
        }
    }

    private class IdHandler
    extends DataElementHandler {
        public IdHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            BusinessParameterHandler.this.id = this.getData();
        }
    }

    private class DefaultValueHandler
    extends DataElementHandler {
        public DefaultValueHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            BusinessParameterHandler.this.defaultValue = this.getData();
        }
    }
}

