/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.fuego;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.GenericContent;
import oracle.bpm.project.compile.exceptions.DesignLoadingException;
import oracle.bpm.project.io.serializers.model.fuego.AbstractHandler;
import oracle.bpm.project.io.serializers.model.fuego.HandlerProvider;
import oracle.bpm.project.io.serializers.model.fuego.ParsingStoppedException;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.util.Identifier;
import oracle.bpm.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RootHandler
extends AbstractHandler
implements ContentHandler {
    protected XMLReader reader_d;
    protected List validTags_d;
    private HandlerProvider handlerProvider;
    private InputSource inputSrc_d;
    private boolean lazy = false;
    private Object processContent;
    private File sourceFile;
    private String sourceName;
    private List<String> warnings = new ArrayList<String>();

    public RootHandler(InputStream reader, HandlerProvider provider, boolean lazy) throws DesignLoadingException {
        this.lazy = lazy;
        this.setSource(new InputSource(reader), provider);
    }

    protected RootHandler(Reader reader, HandlerProvider content) throws DesignLoadingException {
        this(new InputSource(reader), content, null);
    }

    protected RootHandler(InputSource source, HandlerProvider content, List validTags) throws DesignLoadingException {
        this(source, null, content, validTags);
    }

    protected RootHandler(InputSource source, String sourceName, HandlerProvider content, List validTags) throws DesignLoadingException {
        this.root = this;
        this.validTags_d = validTags;
        this.parentHandler_d = this;
        this.tagName_d = "root";
        this.setSource(source, content);
        this.sourceName = sourceName;
        this.load();
    }

    public static void main(String[] argv) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.newSAXParser();
            new File(argv[0]);
            System.exit(0);
        }
        catch (Exception e) {
            Log.logWarning(e);
        }
    }

    public static RootHandler loadContent(Reader reader, HandlerProvider content) throws DesignLoadingException {
        return new RootHandler(reader, content);
    }

    public static RootHandler loadContent(InputStream stream, String location, HandlerProvider content) throws DesignLoadingException {
        return new RootHandler(new InputSource(stream), location, content, null);
    }

    public static void store(File f, GenericContent content) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(f);
        XmlWriter writer = new XmlWriter(fileOutputStream, Literals.DEFAULT_ENCODING);
        writer.startDocument();
        RootHandler.writeContent(writer, content);
        fileOutputStream.close();
    }

    public static void store(Writer writer, GenericContent content) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        xmlWriter.startDocument();
        RootHandler.writeContent(xmlWriter, content);
    }

    public void setContent(GenericContent content) {
        this.processContent = content;
    }

    public void setCurrentHandler(ContentHandler handler) {
        this.reader_d.setContentHandler(handler);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public HandlerProvider getHandlerProvider() {
        return this.handlerProvider;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public Object getContent() {
        return this.processContent;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void init(Attributes atts) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void load() throws DesignLoadingException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            this.reader_d = sp.getXMLReader();
            this.reader_d.setContentHandler(this);
            this.reader_d.parse(this.inputSrc_d);
        }
        catch (SAXException saxException) {
            if (saxException instanceof ParsingStoppedException) {
                throw DesignLoadingException.endOfInputLoading((Throwable)saxException.getCause(), (File)this.sourceFile);
            }
            throw DesignLoadingException.exceptionLoading((ProjectObject)this.getProcessContent(), (File)this.sourceFile, (String)this.sourceName, (Exception)(saxException.getException() == null ? saxException : saxException.getException()));
        }
        catch (IOException ioe) {
            throw DesignLoadingException.ioExceptionLoading((File)this.sourceFile, (IOException)ioe);
        }
        catch (ParserConfigurationException e) {
            throw DesignLoadingException.exceptionLoading((ProjectObject)this.getProcessContent(), (File)this.sourceFile, (String)this.sourceName, (Exception)e);
        }
    }

    @Override
    protected Object getParentElement() {
        return this.getContent();
    }

    @Override
    protected Object getProjectElement() {
        return this.getContent();
    }

    protected void setSource(InputSource source, HandlerProvider provider) {
        this.processContent = provider.getRootContent();
        this.handlerProvider = provider;
        this.handlerProvider.setRoot(this);
        this.root = this;
        this.inputSrc_d = source;
    }

    private static void writeContent(XmlWriter writer, GenericContent content) throws IOException {
        GenericContent[][] contents;
        writer.startElement(Identifier.uncapitalize(content.getClassName()));
        Properties props = content.getProperties();
        for (Object o : props.keySet()) {
            String propertyName = (String)o;
            String propertyValue = props.getProperty(propertyName);
            writer.printAttribute(Identifier.uncapitalize(propertyName), propertyValue);
        }
        GenericContent[][] arr$ = contents = content.getContents();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            GenericContent[] innerContent;
            for (GenericContent genericContent : innerContent = arr$[i$]) {
                RootHandler.writeContent(writer, genericContent);
            }
        }
        writer.endElement();
    }
}

