/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.fuego;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.io.serializers.model.fuego.AbstractHandler;
import oracle.bpm.project.io.serializers.model.fuego.RootHandler;
import oracle.bpm.project.io.serializers.model.fuego.UnknownHandler;
import oracle.bpm.util.Identifier;

public abstract class HandlerProvider
extends AbstractHandler {
    protected HandlerProvider handlerProvider;
    private Map<String, AbstractHandler> handlers = new HashMap<String, AbstractHandler>();

    public abstract Object getRootContent();

    public void startLoading() {
    }

    public void stopLoading() {
    }

    public AbstractHandler getHandler(AbstractHandler parentHandler, String tagName) {
        AbstractHandler handler = this.handlers.get(tagName);
        if (handler != null) {
            handler.init(this.root, parentHandler, tagName);
            return handler;
        }
        try {
            handler = (AbstractHandler)this.getClass().getMethod("create" + Identifier.capitalize(tagName) + "Handler", AbstractHandler.class, String.class).invoke((Object)this, parentHandler, tagName);
        }
        catch (NoSuchMethodException e) {
            handler = this.createHandler(parentHandler, tagName);
            if (handler == null) {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (handler == null) {
            return new UnknownHandler(this.root, this, tagName);
        }
        if (this.mustCacheHandler(tagName)) {
            this.handlers.put(tagName, handler);
        }
        return handler;
    }

    public HandlerProvider getHandlerProvider() {
        return this.handlerProvider;
    }

    public void setRoot(RootHandler rootHandler) {
        this.root = rootHandler;
    }

    public AbstractHandler createHandler(AbstractHandler handler, String tagName) {
        return null;
    }

    protected boolean mustCacheHandler(String tagName) {
        return true;
    }
}

