/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.fuego;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.log.Log;
import oracle.bpm.project.GenericContent;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.io.serializers.model.fuego.ParsingStoppedException;
import oracle.bpm.project.io.serializers.model.fuego.RootHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractHandler
implements ContentHandler {
    protected Object parentElement_d;
    protected ContentHandler parentHandler_d;
    protected RootHandler root;
    protected String tagName_d;

    public AbstractHandler() {
    }

    public AbstractHandler(RootHandler root, AbstractHandler parentHandler, String tagName) {
        this.init(root, parentHandler, tagName);
    }

    public abstract void init(Attributes var1) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (qName.equals(this.tagName_d)) {
                this.root.setCurrentHandler(this.parentHandler_d);
            }
        }
        catch (Exception e) {
            Log.logSevere(e);
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void init(RootHandler root, AbstractHandler parentHandler, String tagName) {
        this.clear();
        this.parentHandler_d = parentHandler;
        this.parentElement_d = parentHandler.getProjectElement();
        this.tagName_d = tagName;
        this.root = root;
        root.setCurrentHandler(this);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (this.root.validTags_d != null && !this.root.validTags_d.contains(qName)) {
                return;
            }
            if (this.root.isLazy() && this.getProcessContent().isProcessInfoLoaded(qName)) {
                throw new ParsingStoppedException(qName);
            }
            AbstractHandler handler = this.root.getHandlerProvider().getHandler(this, qName);
            handler.init(atts);
        }
        catch (NoSuchMethodException e) {
            Log.logWarning(e);
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            Log.logWarning(e);
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            Log.logWarning(e);
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    protected abstract Object getProjectElement();

    protected Map<String, String> getPropertiesFor(Attributes atts) {
        HashMap<String, String> result = new HashMap<String, String>();
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String key = atts.getQName(i);
            String value = atts.getValue(i);
            result.put(key, value);
        }
        return result;
    }

    protected Object getParentElement() {
        return this.parentElement_d;
    }

    protected ProcessContent getProcessContent() {
        return (ProcessContent)this.root.getContent();
    }

    protected void setProperties(Attributes atts) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ProjectObjectImpl content;
        Object projectElement = this.getProjectElement();
        if (projectElement instanceof GenericContent) {
            ((GenericContent)projectElement).setProperties(atts);
            content = (GenericContent)projectElement;
        }
        if (projectElement instanceof ProjectObjectImpl) {
            content = (ProjectObjectImpl)projectElement;
            content.setProperties(atts, null);
            ProjectObjectImpl processObject = (ProjectObjectImpl)this.root.getContent();
        }
    }

    protected void setProperties(Attributes atts, List validValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            ProjectObjectImpl content;
            if (this.getProjectElement() instanceof GenericContent) {
                ((GenericContent)this.getProjectElement()).setProperties(atts, validValues);
                content = (GenericContent)this.getProjectElement();
            }
            if (this.getProjectElement() instanceof ProjectObjectImpl) {
                content = (ProjectObjectImpl)this.getProjectElement();
                content.setProperties(atts, validValues);
                ProcessObjectImpl processObject = (ProcessObjectImpl)this.root.getContent();
            }
        }
        catch (Exception e) {
            Log.logSevere(e);
        }
    }

    protected void setProperty(String key, String value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            ProjectObjectImpl content;
            if (this.getProjectElement() instanceof GenericContent) {
                ((GenericContent)this.getProjectElement()).setProperty(key, value);
                content = (GenericContent)this.getProjectElement();
            }
            if (this.getProjectElement() instanceof ProjectObjectImpl) {
                content = (ProjectObjectImpl)this.getProjectElement();
                content.setProperty(key, value);
                ProcessObjectImpl processObjectImpl = (ProcessObjectImpl)this.root.getContent();
            }
        }
        catch (Exception e) {
            Log.logSevere(e);
        }
    }

    protected String buildAttributesString(Attributes atts) {
        StringBuffer props = new StringBuffer("");
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getQName(i);
            String value = atts.getValue(i);
            props.append("  [name: " + attname + ", value: " + value + "]");
        }
        return props.toString();
    }

    protected void clear() {
    }
}

