/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.documentation;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Id;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.ObjectFactory;
import oracle.bpm.project.io.bpmn.jaxb.extensions.documentation.ProcessDocumentation;
import oracle.bpm.project.io.serializers.model.documentation.ProcessDocumentationVisitor;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;

public class DocumentationFileGenerator {
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext(ObjectFactory.class);
    private static final String DOC_SUFFIX = "Documentation.xml";
    private static final String OLD_DOC_SUFFIX = "_doc.xml";

    private DocumentationFileGenerator() {
    }

    public static String generateDocumentationFileName(@NotNull Process process) {
        return process.getId() + DOC_SUFFIX;
    }

    @Deprecated
    public static String generateOldDocumentationFileName(@NotNull Process process) {
        return process.getId() + OLD_DOC_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void generateDocumentationFileFor(@NotNull Process process) throws ProjectException {
        OutputStreamWriter writer = null;
        VFileOutputStream outputStream = null;
        VFile documentationFile = DocumentationFileGenerator.getDocumentationsFile(process);
        try {
            outputStream = new VFileOutputStream(documentationFile);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            JAXBContext jaxbContext = JAXB_CONTEXT;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            writer.write("<?oracleBPM version=\"" + Id.getAbsoluteVersion() + "\" fileRevision=\"" + "20100225" + "\"?>\n");
            marshaller.marshal((Object)DocumentationFileGenerator.getProcessDocumentation(process), (Writer)writer);
        }
        catch (IOException e) {
            Log.logSevere(e);
            StreamUtils.close(new Closeable[]{outputStream});
            StreamUtils.close(writer);
        }
        catch (JAXBException e2) {
            Log.logSevere(e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.close(new Closeable[]{outputStream});
                    StreamUtils.close(writer);
                    throw throwable;
                }
            }
            StreamUtils.close(new Closeable[]{outputStream});
            StreamUtils.close(writer);
        }
        StreamUtils.close(new Closeable[]{outputStream});
        StreamUtils.close(writer);
    }

    public static VFile getDocumentationsFile(@NotNull Process process) throws ProjectException {
        ProjectWriter writer = process.getProject().getWriter();
        ProjectFileSystem fileSystem = writer.getProjectFileSystem();
        VFileSystem dataFileSystem = fileSystem.getDataFileSystem();
        return dataFileSystem.createFile(dataFileSystem.getRoot(), DocumentationFileGenerator.generateDocumentationFileName(process));
    }

    public static void deleteDocumentationFileFor(@NotNull Process process) throws ProjectException {
        try {
            DocumentationFileGenerator.getDocumentationsFile(process).delete();
        }
        catch (IOException e) {
            Log.logSevere(e);
        }
    }

    private static ProcessDocumentation getProcessDocumentation(@NotNull Process process) {
        ProcessDocumentationVisitor processDocumentationVisitor = new ProcessDocumentationVisitor();
        try {
            processDocumentationVisitor.visit(process);
        }
        catch (ProjectException e) {
            Log.logSevere(e);
        }
        return processDocumentationVisitor.getProcessDocumentation();
    }
}

