/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.log.Log;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.io.bpmn.jaxb.TActivity;
import oracle.bpm.project.io.bpmn.jaxb.TArtifact;
import oracle.bpm.project.io.bpmn.jaxb.TAssignment;
import oracle.bpm.project.io.bpmn.jaxb.TAttributeExpression;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElement;
import oracle.bpm.project.io.bpmn.jaxb.TBoundaryEvent;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessIndicator;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessIndicators;
import oracle.bpm.project.io.bpmn.jaxb.TBusinessRuleTask;
import oracle.bpm.project.io.bpmn.jaxb.TCallActivity;
import oracle.bpm.project.io.bpmn.jaxb.TCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TComplexGateway;
import oracle.bpm.project.io.bpmn.jaxb.TCounter;
import oracle.bpm.project.io.bpmn.jaxb.TDataAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDataInput;
import oracle.bpm.project.io.bpmn.jaxb.TDataInputAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDataObject;
import oracle.bpm.project.io.bpmn.jaxb.TDataOutput;
import oracle.bpm.project.io.bpmn.jaxb.TDataOutputAssociation;
import oracle.bpm.project.io.bpmn.jaxb.TDefinitions;
import oracle.bpm.project.io.bpmn.jaxb.TEndEvent;
import oracle.bpm.project.io.bpmn.jaxb.TErrorEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TEvent;
import oracle.bpm.project.io.bpmn.jaxb.TEventBasedGateway;
import oracle.bpm.project.io.bpmn.jaxb.TEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TExclusiveGateway;
import oracle.bpm.project.io.bpmn.jaxb.TExpression;
import oracle.bpm.project.io.bpmn.jaxb.TFlowElement;
import oracle.bpm.project.io.bpmn.jaxb.TFlowNode;
import oracle.bpm.project.io.bpmn.jaxb.TFormalExpression;
import oracle.bpm.project.io.bpmn.jaxb.TGateway;
import oracle.bpm.project.io.bpmn.jaxb.TInclusiveGateway;
import oracle.bpm.project.io.bpmn.jaxb.TInputOutputSpecification;
import oracle.bpm.project.io.bpmn.jaxb.TIntermediateCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TIntermediateThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.TLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TManualTask;
import oracle.bpm.project.io.bpmn.jaxb.TMeasurementMark;
import oracle.bpm.project.io.bpmn.jaxb.TMessageEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TMultiInstanceLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TParallelGateway;
import oracle.bpm.project.io.bpmn.jaxb.TPeopleGroup;
import oracle.bpm.project.io.bpmn.jaxb.TPerformer;
import oracle.bpm.project.io.bpmn.jaxb.TProcess;
import oracle.bpm.project.io.bpmn.jaxb.TReceiveTask;
import oracle.bpm.project.io.bpmn.jaxb.TRootElement;
import oracle.bpm.project.io.bpmn.jaxb.TScript;
import oracle.bpm.project.io.bpmn.jaxb.TScriptTask;
import oracle.bpm.project.io.bpmn.jaxb.TSendTask;
import oracle.bpm.project.io.bpmn.jaxb.TSequenceFlow;
import oracle.bpm.project.io.bpmn.jaxb.TServiceTask;
import oracle.bpm.project.io.bpmn.jaxb.TSignalEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TStandardLoopCharacteristics;
import oracle.bpm.project.io.bpmn.jaxb.TStartEvent;
import oracle.bpm.project.io.bpmn.jaxb.TSubProcess;
import oracle.bpm.project.io.bpmn.jaxb.TTerminateEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TTextAnnotation;
import oracle.bpm.project.io.bpmn.jaxb.TThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.TTimerEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TUserTask;
import oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TAnnotations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBooleanFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessDataRange;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBusinessRuleTaskData;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDataObjectType;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TFeatureSet;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TGraphicsAttributes;
import oracle.bpm.project.io.bpmn.jaxb.extensions.THumanTask;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TIntegerFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalization;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalizedContent;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TLocalizedItemsContainer;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOracleExtensions;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TParticipant;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TPosition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TSize;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TStringFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TTypeRef;
import oracle.bpm.project.io.serializers.model.bpmn.IoUtils;
import oracle.bpm.project.io.utils.Utils;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.features.ProcessLayoutFeature;
import oracle.bpm.project.model.features.SingleDataAssociationFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Artifact;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.CheckedEventTriggerAdapter;
import oracle.bpm.project.model.processes.CheckedFlowNodeAdapter;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventBasedGatewayType;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FeatureContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.MessageEventDefinition;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.dataassociations.DataAssociationItemRefImpl;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Locales;
import oracle.bpm.xml.JaxbHelper;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BPMN20Loader {
    private NodeContainer nodeContainer;
    private Process process;
    private InputStream stream;
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext(oracle.bpm.project.io.bpmn.jaxb.ObjectFactory.class, ObjectFactory.class);

    public BPMN20Loader(Process process, InputStream stream) {
        this.nodeContainer = process;
        this.process = process;
        this.stream = stream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() throws UnsupportedEncodingException, ParserException, ProjectException {
        try {
            JAXBContext jc = JAXB_CONTEXT;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal(this.stream);
            if (!(unmarshalledObject instanceof JAXBElement)) throw new ParserException("Invalid JAXB element found");
            Object value = ((JAXBElement)unmarshalledObject).getValue();
            if (value != null && value instanceof TDefinitions) {
                TRootElement tRootElement;
                TDefinitions definitions = (TDefinitions)value;
                List<JAXBElement<? extends TRootElement>> elementList = definitions.getRootElement();
                for (JAXBElement<? extends TRootElement> jaxbElement : elementList) {
                    tRootElement = (TRootElement)jaxbElement.getValue();
                    if (!(tRootElement instanceof TProcess)) continue;
                    this.load(tRootElement);
                }
                for (JAXBElement<? extends TRootElement> jaxbElement : elementList) {
                    tRootElement = (TRootElement)jaxbElement.getValue();
                    if (tRootElement instanceof TProcess) continue;
                    this.load(tRootElement);
                }
            }
        }
        catch (JAXBException e) {
            try {
                Log.logFatal(e);
                throw new ParserException((Throwable)e);
                catch (Exception t) {
                    Log.logFatal(t);
                    throw new ParserException((Throwable)t);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(this.stream);
                throw throwable;
            }
        }
        StreamUtils.close(this.stream);
    }

    private static void loadOutputDataAssociations(DataAssociationSet outputAssociationSet, List<TDataOutputAssociation> outputAssociationList) throws ProjectException {
        if (outputAssociationList != null) {
            for (TDataOutputAssociation tDataOutputAssociation : outputAssociationList) {
                BPMN20Loader.loadDataAssociation(outputAssociationSet, tDataOutputAssociation);
            }
        }
    }

    private static void loadInputDataAssociations(DataAssociationSet inputAssociationSet, List<TDataInputAssociation> inputAssociationList) throws ProjectException {
        if (inputAssociationList != null) {
            for (TDataInputAssociation tDataInputAssociation : inputAssociationList) {
                BPMN20Loader.loadDataAssociation(inputAssociationSet, tDataInputAssociation);
            }
        }
    }

    private static void loadDataAssociation(DataAssociationSet dataAssociationSet, TDataAssociation tDataAssociation) throws ProjectException {
        List<String> sourceRefs = tDataAssociation.getSourceRef();
        String targetRef = tDataAssociation.getTargetRef();
        List<TAssignment> tAssignments = tDataAssociation.getAssignment();
        if (!Str.isEmpty(targetRef)) {
            TOracleExtensions associationExtensions = IoUtils.getOracleExtensionsFrom(tDataAssociation);
            for (TAssignment tAssignment : tAssignments) {
                TOracleExtensions assignmentExtensions = IoUtils.getOracleExtensionsFrom(tAssignment);
                boolean isCustom = assignmentExtensions.getDataAssignment().isIsCustom();
                String expressionModeId = assignmentExtensions.getDataAssignment().getMode();
                ExpressionMode expressionMode = expressionModeId != null ? ExpressionMode.fromId((String)expressionModeId) : ExpressionMode.SIMPLE;
                dataAssociationSet.setExpressionMode(expressionMode);
                Expression fromExpression = BPMN20Loader.createExpression(tAssignment.getFrom(), expressionMode);
                Expression toExpression = BPMN20Loader.createExpression(tAssignment.getTo(), expressionMode);
                DataAssociationItemEndpoint sourceEndpoint = isCustom ? DataAssociationItemEndpoint.CUSTOM_SOURCE : DataAssociationItemEndpoint.SOURCE;
                DataAssociationItemEndpoint targetEndpoint = isCustom ? DataAssociationItemEndpoint.CUSTOM_TARGET : DataAssociationItemEndpoint.TARGET;
                ArrayList<DataAssociationItemRefImpl> sourceRefItems = new ArrayList<DataAssociationItemRefImpl>();
                for (String ref : sourceRefs) {
                    DataAssociationItemRefImpl dataAssociationItemRef = new DataAssociationItemRefImpl(ref, false);
                    sourceRefItems.add(dataAssociationItemRef);
                }
                ArrayList<DataAssociationItemRefImpl> targetRefItems = new ArrayList<DataAssociationItemRefImpl>();
                targetRefItems.add(new DataAssociationItemRefImpl(targetRef, false));
                if (associationExtensions != null) {
                    for (String otherRef : associationExtensions.getOtherRef()) {
                        DataAssociationItemRefImpl otherRefItem = new DataAssociationItemRefImpl(otherRef, true);
                        sourceRefItems.add(otherRefItem);
                        targetRefItems.add(otherRefItem);
                    }
                }
                DataAssociationItem source = dataAssociationSet.createDataAssociationItem(sourceEndpoint, fromExpression, CollectionUtils.asSequence(sourceRefItems));
                DataAssociationItem target = dataAssociationSet.createDataAssociationItem(targetEndpoint, toExpression, CollectionUtils.asSequence(targetRefItems));
                DataAssociation dataAssociation = dataAssociationSet.createDataAssociation(source, target);
                dataAssociation.setIsCustom(isCustom);
                dataAssociationSet.addDataAssociation(dataAssociation);
            }
            if (tDataAssociation.getTransformation() != null) {
                TFormalExpression transformation = tDataAssociation.getTransformation();
                TOracleExtensions oracleExtensions = IoUtils.getOracleExtensionsFrom(transformation);
                String transformationName = oracleExtensions.getExternalTransformation().getResource().replace(".xsl", "");
                DataTransformation dataTransformation = dataAssociationSet.createDataTransformation(CollectionUtils.asSequence(sourceRefs), targetRef, transformationName);
                dataAssociationSet.addDataTransformation(dataTransformation);
            }
        }
    }

    private static Expression createExpression(@NotNull TFormalExpression tFormalExpression, @NotNull ExpressionMode mode) {
        List<Object> content = tFormalExpression.getContent();
        String expression = content != null && !content.isEmpty() ? content.get(0) : "";
        Map<String, URI> namespaces = BPMN20Loader.createNamespacesMapFor(tFormalExpression.getOtherAttributes());
        XPathExpression result = new XPathExpression(expression, namespaces);
        result.setMode(mode);
        return result;
    }

    private static Map<String, URI> createNamespacesMapFor(Map<QName, String> otherAttributes) {
        if (otherAttributes == null || otherAttributes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, URI> namespaces = new HashMap<String, URI>();
        for (Map.Entry<QName, String> entry : otherAttributes.entrySet()) {
            QName qName = entry.getKey();
            if (!"xmlns".equals(qName.getPrefix())) continue;
            try {
                namespaces.put(qName.getLocalPart(), new URI(entry.getValue()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return namespaces;
    }

    private static void loadTransitionData(TSequenceFlow tSequenceFlow, SequenceFlow sequenceFlow) {
        TExpression tExpression = tSequenceFlow.getConditionExpression();
        if (tExpression != null) {
            ConditionalFlow conditionalFlow = sequenceFlow.toConditionalFlow();
            conditionalFlow.setCondition(BPMN20Loader.buildExpressionFrom(tSequenceFlow, tExpression));
        }
    }

    private static Expression buildExpressionFrom(TBaseElement tBaseElement, TExpression tExpression) {
        Expression expression;
        oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression expressionExtension = IoUtils.getNamedOracleExtension(oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression.class, tBaseElement);
        if (expressionExtension != null) {
            expression = BPMN20Loader.getExpressionFromExtension(tExpression, expressionExtension);
        } else {
            expressionExtension = IoUtils.getNamedOracleExtension(oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression.class, tExpression);
            expression = BPMN20Loader.getExpressionFromExtension(tExpression, expressionExtension);
        }
        if (expression == null && (expression = BPMN20Loader.getExpressionFrom(tExpression)) != null) {
            expression.setMode(ExpressionMode.XPATH);
        }
        return expression;
    }

    private static Expression getExpressionFromExtension(TExpression tExpression, oracle.bpm.project.io.bpmn.jaxb.extensions.TExpression expressionExtension) {
        Expression expression = BPMN20Loader.getExpressionFrom(tExpression);
        if (expression != null && expressionExtension != null) {
            ExpressionMode mode = ExpressionMode.fromId((String)expressionExtension.getMode());
            expression.setMode(mode);
        }
        return expression;
    }

    private static void loadExtensions(TFlowElement value, FlowNode flowNode) {
        TOracleExtensions oracleExtensions = IoUtils.getOracleExtensionsFrom(value);
        if (oracleExtensions != null) {
            BPMN20Loader.loadOracleExtensions(oracleExtensions, flowNode);
        }
    }

    private static void loadSequenceFlowExtensions(TFlowElement value, SequenceFlow sequenceFlow) {
        TOracleExtensions oracleExtensions = IoUtils.getOracleExtensionsFrom(value);
        if (oracleExtensions != null) {
            BPMN20Loader.loadOracleExtensions(oracleExtensions, sequenceFlow);
        }
        if (!SequenceFlow.NULL_CONTROL_POINT.equals(sequenceFlow.getControlPoint()) && sequenceFlow.getRoutingMode() == RoutingMode.STRAIGHT) {
            sequenceFlow.setRoutingData(RoutingMode.CURVED, sequenceFlow.getControlPoint());
        }
        if (SequenceFlow.NULL_CONTROL_POINT.equals(sequenceFlow.getControlPoint()) && sequenceFlow.getRoutingMode() != RoutingMode.STRAIGHT) {
            sequenceFlow.setRoutingData(RoutingMode.STRAIGHT, SequenceFlow.NULL_CONTROL_POINT);
        }
    }

    private static void loadOracleExtensions(TOracleExtensions tOracleExtensions, SequenceFlow sequenceFlow) {
        BPMN20Loader.loadFeatures(sequenceFlow, tOracleExtensions);
    }

    private static void loadOracleExtensions(TOracleExtensions tOracleExtensions, FlowNode flowNode) {
        BPMN20Loader.loadGraphicalAttributes(flowNode, tOracleExtensions);
        BPMN20Loader.loadFeatures(flowNode, tOracleExtensions);
        BPMN20Loader.loadLocalization(flowNode, tOracleExtensions);
    }

    private static void loadLocalization(Localizable localizable, TOracleExtensions tOracleExtensions) {
        if (localizable != null && tOracleExtensions != null && tOracleExtensions.getLocalization() != null) {
            BPMN20Loader.loadLocalizationInto(localizable.getLabelMap(), localizable.getDescriptionMap(), localizable.getDocumentationMap(), localizable.getUseCaseDocumentationMap(), tOracleExtensions);
        }
    }

    private static void loadLocalizationInto(LocaleStringMap labelMap, LocaleStringMap descriptionMap, LocaleStringMap documentationMap, LocaleStringMap useCaseDocumentationMap, TOracleExtensions tOracleExtensions) {
        TLocalization tLocalization = tOracleExtensions.getLocalization();
        if (tLocalization != null) {
            BPMN20Loader.addLocalizationItems(labelMap, tLocalization.getLabel());
            BPMN20Loader.addLocalizationItems(descriptionMap, tLocalization.getDescription());
            BPMN20Loader.addLocalizationItems(documentationMap, tLocalization.getDocumentation());
            BPMN20Loader.addLocalizationItems(useCaseDocumentationMap, tLocalization.getUseCaseDocumentation());
        }
    }

    private static void addLocalizationItems(LocaleStringMap localeStringMap, TLocalizedItemsContainer tLocalizedItemsContainer) {
        List<TLocalizedContent> items;
        if (tLocalizedItemsContainer != null && localeStringMap != null && !(items = tLocalizedItemsContainer.getLocalizedContent()).isEmpty()) {
            for (TLocalizedContent item : items) {
                localeStringMap.put(Locales.valueOf(item.getLanguage()), item.getContent());
            }
        }
    }

    private static void loadOracleExtensions(TOracleExtensions tOracleExtensions, Lane lane) {
        BPMN20Loader.loadGraphicalAttributes(lane, tOracleExtensions);
    }

    private static void loadGraphicalAttributes(Lane lane, TOracleExtensions oracleExtensions) {
        TGraphicsAttributes graphicAtts = oracleExtensions.getGraphicsAttributes();
        if (graphicAtts != null) {
            TPosition position = graphicAtts.getPosition();
            TSize size = graphicAtts.getSize();
            lane.asMutable().setOffset(position.getX());
            lane.asMutable().setSize(size.getWidth());
        }
    }

    private static void loadGraphicalAttributes(Positional positional, TOracleExtensions oracleExtensions) {
        TGraphicsAttributes graphicAtts = oracleExtensions.getGraphicsAttributes();
        if (graphicAtts != null) {
            TPosition position = graphicAtts.getPosition();
            TSize size = graphicAtts.getSize();
            positional.setX(position.getX());
            positional.setY(position.getY());
            positional.setHeight(size.getHeight());
            positional.setWidth(size.getWidth());
        }
    }

    private static void loadFeatures(FeatureContainer featureContainer, TOracleExtensions tOracleExtensions) {
        TFeatureSet featureSet = tOracleExtensions.getFeatureSet();
        Map<String, Object> featuresMap = BPMN20Loader.buildPrimitiveFeaturesMap(featureSet);
        Features features = featureContainer.getFeatures();
        for (PersistentFeature persistentModelFeature : features.persistentFeatures()) {
            persistentModelFeature.fill(featuresMap);
        }
        BPMN20Loader.loadAnnotations(featureContainer, featureSet);
    }

    private static void loadAnnotations(FeatureContainer featureContainer, TFeatureSet tFeatureSet) {
        AnnotationsFeature annotationsFeature;
        TAnnotations tAnnotations = tFeatureSet.getAnnotations();
        if (tAnnotations != null && (annotationsFeature = featureContainer.getFeature(AnnotationsFeature.class)) != null) {
            Map<String, Object> userAnnotationsMap = BPMN20Loader.buildPrimitiveFeaturesMap(tAnnotations.getUserAnnotations());
            Map<String, Object> hiddenAnnotationsMap = BPMN20Loader.buildPrimitiveFeaturesMap(tAnnotations.getHiddenAnnotations());
            annotationsFeature.fill(userAnnotationsMap, hiddenAnnotationsMap);
        }
    }

    private static Map<String, Object> buildPrimitiveFeaturesMap(TFeatureSet featureSet) {
        HashMap<String, Object> featuresMap = new HashMap<String, Object>();
        if (featureSet != null) {
            if (featureSet.getBooleanFeature() != null) {
                ArrayList<TBooleanFeature> booleanFeatures = new ArrayList<TBooleanFeature>(featureSet.getBooleanFeature());
                for (TBooleanFeature booleanFeature : booleanFeatures) {
                    featuresMap.put(booleanFeature.getName(), String.valueOf(booleanFeature.isValue()));
                }
            }
            if (featureSet.getStringFeature() != null) {
                ArrayList<TStringFeature> stringFeatures = new ArrayList<TStringFeature>(featureSet.getStringFeature());
                for (TStringFeature stringFeature : stringFeatures) {
                    featuresMap.put(stringFeature.getName(), stringFeature.getValue());
                }
            }
            if (featureSet.getIntegerFeature() != null) {
                ArrayList<TIntegerFeature> integerFeatures = new ArrayList<TIntegerFeature>(featureSet.getIntegerFeature());
                for (TIntegerFeature integerFeature : integerFeatures) {
                    featuresMap.put(integerFeature.getName(), String.valueOf(integerFeature.getValue()));
                }
            }
            if (featureSet.getAny() != null) {
                List<Object> otherFeatures = featureSet.getAny();
                for (Object jaxbElement : otherFeatures) {
                    Object value;
                    if (!(jaxbElement instanceof JAXBElement) || !((value = ((JAXBElement)jaxbElement).getValue()) instanceof TAttributeExpression)) continue;
                    TAttributeExpression attributeExpression = (TAttributeExpression)value;
                    featuresMap.put(attributeExpression.getAttributeName(), BPMN20Loader.createExpression(attributeExpression, ExpressionMode.XPATH));
                }
            }
            for (TFeatureSet innerFeatureSet : featureSet.getFeatureSet()) {
                featuresMap.putAll(BPMN20Loader.buildPrimitiveFeaturesMap(innerFeatureSet));
            }
        }
        return featuresMap;
    }

    private static Throwable getUnexpectedElementException(TFlowElement tFlowElement) {
        return new Exception("Unknown element found: " + tFlowElement.getName() + " / Class: " + tFlowElement.getClass());
    }

    private static Expression getExpressionFrom(TExpression tExpression) {
        XPathExpression retVal = null;
        if (tExpression != null) {
            String expressionValue = IoUtils.getExpressionStringContent(tExpression);
            if (tExpression instanceof TFormalExpression) {
                TFormalExpression tFormalExpression = (TFormalExpression)tExpression;
                String language = tFormalExpression.getLanguage();
                ExpressionLanguage expLanguage = null;
                if (language != null) {
                    expLanguage = ExpressionLanguage.fromId((String)language);
                }
                if (expLanguage != null) {
                    Map<String, URI> namespaces = BPMN20Loader.createNamespacesMapFor(tFormalExpression.getOtherAttributes());
                    retVal = new XPathExpression(expressionValue, namespaces);
                }
            } else {
                retVal = new XPathExpression(expressionValue);
            }
        }
        return retVal;
    }

    private void load(TRootElement value) throws ProjectException {
        if (value instanceof TProcess) {
            this.load((TProcess)value);
        } else if (value instanceof TPeopleGroup) {
            this.load((TPeopleGroup)value);
        }
    }

    private void load(TPeopleGroup tPeopleGroup) throws ProjectException {
        String peopleGroupId = tPeopleGroup.getId();
        Lane lane = this.process.createLane(peopleGroupId);
        lane.setIsParametric(false);
        TOracleExtensions oracleExtensions = IoUtils.getOracleExtensionsFrom(tPeopleGroup);
        if (oracleExtensions != null) {
            BPMN20Loader.loadOracleExtensions(oracleExtensions, lane);
        }
        this.nodeContainer.addChild(lane);
    }

    private void load(TProcess tProcess) throws ProjectException {
        this.process.setId(tProcess.getId());
        this.loadProcessExtensions(tProcess, this.process);
        List<JAXBElement<? extends TFlowElement>> elementList = tProcess.getFlowElement();
        this.loadActivities(elementList);
        this.loadOtherFlowElements(elementList);
        this.loadArtifacts(tProcess.getArtifact());
        this.loadDataAssociations(tProcess);
        ProcessContent processContent = (ProcessContent)this.process;
        if (processContent.getFileRevision() < Integer.valueOf("20100210")) {
            this.setUpDefaultConversation();
        }
    }

    private void loadProcessExtensions(TProcess tProcess, Process process) {
        TOracleExtensions oracleExtensions = IoUtils.getOracleExtensionsFrom(tProcess);
        this.loadOracleExtensions(oracleExtensions, process);
        if (process.getFeature(ProcessLayoutFeature.class).isUndefined()) {
            process.getFeature(ProcessLayoutFeature.class).setHorizontal();
        }
    }

    private void loadOracleExtensions(TOracleExtensions tOracleExtensions, Process process) {
        if (tOracleExtensions != null) {
            BPMN20Loader.loadFeatures(process, tOracleExtensions);
        }
    }

    private void setUpDefaultConversation() {
        StartEvent startEvent = ModelUtils.getStartEvent(this.process);
        EndEvent endEvent = ModelUtils.getAnyEndEvent(this.process);
        if (!this.process.isCallableSubprocess()) {
            if (startEvent != null && startEvent.getEventTriggerType() == EventTriggerType.MESSAGE && endEvent != null && endEvent.getEventTriggerType() == EventTriggerType.MESSAGE) {
                if (endEvent.getConversationInitiator() == null) {
                    endEvent.setConversationInitiator(startEvent);
                }
                this.setDefaultOperationName(startEvent);
                this.setDefaultOperationName(endEvent);
            } else if (startEvent != null && startEvent.getEventTriggerType() == EventTriggerType.MESSAGE) {
                this.setDefaultOperationName(startEvent);
            }
        }
    }

    private void setDefaultOperationName(ConversationEnabled node) {
        if (!ConversationHelper.hasImplementation((ConversationEnabled)node)) {
            ConversationEnabled initiator = node.getConversationInitiator();
            String operationName = node.getId();
            if (initiator != null && initiator.isSync()) {
                operationName = initiator.getDefinedOperationName();
            }
            node.setDefinedOperationName(operationName);
        }
    }

    private void loadArtifacts(List<TArtifact> tArtifacts) throws ProjectException {
        for (TArtifact tArtifact : tArtifacts) {
            Artifact artifact = null;
            String artId = tArtifact.getId();
            if (tArtifact instanceof TMeasurementMark) {
                artifact = this.nodeContainer.createMeasurement(artId);
                this.loadBusinessIndicators((Measurement)artifact, this.getTBusinessIndicators(tArtifact));
            } else if (tArtifact instanceof TCounter) {
                artifact = this.nodeContainer.createCounter(artId);
                this.loadBusinessIndicators((Counter)artifact, this.getTBusinessIndicators(tArtifact));
            } else if (tArtifact instanceof TTextAnnotation) {
                artifact = this.nodeContainer.createTextAnnotation(artId);
            }
            if (artifact != null) {
                this.loadOracleExtensions(tArtifact, artifact);
            }
            this.nodeContainer.addChild(artifact);
        }
    }

    private void loadOracleExtensions(TArtifact tArtifact, Artifact artifact) {
        if (tArtifact != null && artifact != null) {
            TOracleExtensions tOracleExtensions = IoUtils.getOracleExtensionsFrom(tArtifact);
            BPMN20Loader.loadFeatures(artifact, tOracleExtensions);
            BPMN20Loader.loadGraphicalAttributes(artifact, tOracleExtensions);
            BPMN20Loader.loadLocalization(artifact, tOracleExtensions);
        }
    }

    private void loadBusinessIndicators(Measurement measurement, TBusinessIndicators tBusinessIndicators) throws ProjectException {
        if (tBusinessIndicators != null) {
            for (TBusinessIndicator tBusinessIndicator : tBusinessIndicators.getBusinessIndicator()) {
                ProjectDataObject projectDataObject = this.nodeContainer.getProject().findDataObject(tBusinessIndicator.getId());
                if (projectDataObject == null) continue;
                measurement.addBusinessIndicator(projectDataObject);
            }
        }
    }

    private void loadBusinessIndicators(Counter counter, TBusinessIndicators tBusinessIndicators) throws ProjectException {
        if (tBusinessIndicators != null) {
            for (TBusinessIndicator tBusinessIndicator : tBusinessIndicators.getBusinessIndicator()) {
                ProjectDataObject projectDataObject = this.nodeContainer.getProject().findDataObject(tBusinessIndicator.getId());
                if (projectDataObject == null) continue;
                counter.addBusinessIndicator(projectDataObject);
            }
        }
    }

    private TBusinessIndicators getTBusinessIndicators(TArtifact tArtifact) {
        for (Object anyObject : tArtifact.getAny()) {
            Object value;
            if (!(anyObject instanceof JAXBElement) || !((value = ((JAXBElement)anyObject).getValue()) instanceof TBusinessIndicators)) continue;
            return (TBusinessIndicators)value;
        }
        return null;
    }

    private void load(TSubProcess tSubProcess, Subprocess subprocess) throws ProjectException {
        NodeContainer oldNodeContainer = this.nodeContainer;
        this.nodeContainer = subprocess;
        List<JAXBElement<? extends TFlowElement>> elementList = tSubProcess.getFlowElement();
        this.loadActivities(elementList);
        this.loadOtherFlowElements(elementList);
        this.loadArtifacts(tSubProcess.getArtifact());
        this.nodeContainer = oldNodeContainer;
    }

    private void loadOtherFlowElements(List<JAXBElement<? extends TFlowElement>> elementList) throws ProjectException {
        for (JAXBElement<? extends TFlowElement> jaxbElement : elementList) {
            TFlowElement value = (TFlowElement)jaxbElement.getValue();
            if (value instanceof TActivity) continue;
            this.load(value);
        }
    }

    private void loadActivities(List<JAXBElement<? extends TFlowElement>> elementList) throws ProjectException {
        for (JAXBElement<? extends TFlowElement> jaxbElement : elementList) {
            TFlowElement value = (TFlowElement)jaxbElement.getValue();
            if (!(value instanceof TActivity)) continue;
            this.load(value);
        }
    }

    private void load(TDataObject tDataObject) throws ProjectException {
        TOracleExtensions oracleExtensions = IoUtils.getOracleExtensionsFrom(tDataObject);
        TDataObjectType tDataObjectType = oracleExtensions.getDataObjectType();
        String id = tDataObject.getId();
        TTypeRef tTypeRef = tDataObjectType.getTypeRef();
        CatalogType type = tTypeRef != null ? this.getCatalogTypeFrom(tTypeRef, false) : this.createCatalogTypeFromTypeName(tDataObjectType.getTypeName());
        if (type != null) {
            TBusinessAttributes attributes;
            DataObject dataObject = this.nodeContainer.createDataObject(id, type);
            Boolean initialize = tDataObjectType.isInitialize();
            if (initialize == null) {
                dataObject.setInitialize(true);
            } else {
                dataObject.setInitialize(initialize);
            }
            if (dataObject instanceof ProjectDataObject && (attributes = tDataObjectType.getBusinessAttributes()) != null) {
                ProjectDataObject projectDataObject = (ProjectDataObject)dataObject;
                String sType = attributes.getType();
                if (sType != null) {
                    BusinessVariableType variableType = BusinessVariableType.valueOf((String)sType);
                    projectDataObject.setBusinessVariableType(variableType);
                    List<TBusinessDataRange> tBusinessDataRange = attributes.getBusinessDataRange();
                    if (!tBusinessDataRange.isEmpty()) {
                        BusinessVariableData businessVariableData = new BusinessVariableData();
                        for (TBusinessDataRange item : tBusinessDataRange) {
                            businessVariableData.addRange(item.getName(), item.getStart(), item.getFinish());
                        }
                        projectDataObject.setBusinessVariableData(businessVariableData);
                    }
                }
            }
            this.nodeContainer.addDataObject(dataObject);
        } else {
            Log.logDebug("[LOADING ERROR] Cannot load type " + tDataObjectType.getTypeName());
        }
    }

    private CatalogType createCatalogTypeFromTypeName(String typeName) {
        ComponentCatalog catalog = this.getComponentCatalog();
        TypeDescription td = TypeFactory.forNameLazy((String)typeName, (ComponentCatalog)catalog).get();
        if (td.isCollection()) {
            System.out.println("Type '" + typeName + "' is a collection and its not supported. " + "Type will be converted into a single type");
            while (td.isCollection()) {
                td = td.getElementType();
            }
        }
        CatalogType type = CatalogTypeImpl.get((TypeRef)td);
        return type;
    }

    private CatalogType getCatalogTypeFrom(TTypeRef tTypeRef, boolean exceptionObject) {
        ComponentCatalog catalog = this.getComponentCatalog();
        CatalogType type = null;
        String namespace = tTypeRef.getNamespace();
        String complexTypeName = tTypeRef.getType();
        String elementName = tTypeRef.getElement();
        String messageName = tTypeRef.getMessage();
        String messageNamespace = tTypeRef.getMessageNamespace();
        String faultName = tTypeRef.getFault();
        Boolean isArray = tTypeRef.isIsArray();
        type = complexTypeName != null ? Utils.createCatalogTypeForSchemaType(complexTypeName, namespace, XmlElementType.TYPE, catalog, exceptionObject, isArray) : (elementName != null ? Utils.createCatalogTypeForSchemaType(elementName, namespace, XmlElementType.ELEMENT, catalog, exceptionObject, isArray) : (faultName != null && messageNamespace != null && messageName != null ? Utils.createCatalogTypeForFaultType(faultName, namespace, messageName, messageNamespace, catalog) : CatalogType.Default.getUnknown(namespace, catalog)));
        return type;
    }

    private ComponentCatalog getComponentCatalog() {
        ComponentCatalog componentCatalog;
        Project project = this.nodeContainer.getProject();
        ComponentCatalog componentCatalog2 = componentCatalog = project != null ? project.getComponentCatalog() : null;
        if (componentCatalog == null) {
            componentCatalog = TypeUtils.getDefaultCatalog();
        }
        return componentCatalog;
    }

    private void load(TFlowElement value) throws ProjectException {
        if (value instanceof TFlowNode) {
            TActivity tActivity;
            FlowNode node = null;
            if (value instanceof TEvent) {
                TEvent tEvent = (TEvent)value;
                node = this.createEventFrom(tEvent);
                BPMN20Loader.loadExtensions(tEvent, node);
                this.loadEventData(tEvent, (Event)node);
            } else if (value instanceof TGateway) {
                TGateway tGateway = (TGateway)value;
                node = this.createGatewayFrom(tGateway);
                BPMN20Loader.loadExtensions(tGateway, node);
                this.loadGatewayData(tGateway, (Gateway)node);
            } else if (value instanceof TActivity) {
                tActivity = (TActivity)value;
                node = this.createActivityFrom(tActivity);
                if (value instanceof TSubProcess) {
                    this.load((TSubProcess)tActivity, (Subprocess)node);
                }
                BPMN20Loader.loadExtensions(tActivity, node);
                this.loadActivityData(tActivity, (Activity)node);
            }
            this.loadDataAssociations(value, node);
            if (value instanceof TActivity) {
                tActivity = (TActivity)value;
                this.loadLoopCharacteristics(tActivity, (Activity)node);
            }
        } else if (value instanceof TSequenceFlow) {
            TSequenceFlow tSequenceFlow = (TSequenceFlow)value;
            SequenceFlow sequenceFlow = this.createSequenceFlowFrom(tSequenceFlow);
            if (sequenceFlow != null) {
                BPMN20Loader.loadSequenceFlowExtensions(tSequenceFlow, sequenceFlow);
                BPMN20Loader.loadTransitionData(tSequenceFlow, sequenceFlow);
            }
        } else if (value instanceof TDataObject) {
            this.load((TDataObject)value);
        }
    }

    private void loadActivityData(TActivity tActivity, Activity activity) throws ProjectException {
        LoadingFlowNodeHandler loadingFlowNodeHandler = new LoadingFlowNodeHandler(tActivity);
        ModelUtils.handleFlowNodeChecked(activity, loadingFlowNodeHandler);
    }

    private void loadLoopCharacteristics(TActivity tActivity, Activity activity) {
        TLoopCharacteristics value;
        JAXBElement<? extends TLoopCharacteristics> characteristics = tActivity.getLoopCharacteristics();
        if (characteristics != null && (value = (TLoopCharacteristics)characteristics.getValue()) != null) {
            if (value instanceof TStandardLoopCharacteristics) {
                TStandardLoopCharacteristics slc = (TStandardLoopCharacteristics)value;
                activity.setLoopCharacteristicsType(LoopCharacteristicsType.LOOP);
                LoopCharacteristics baseLoop = activity.getLoopCharacteristics();
                if (baseLoop != null) {
                    Loop loop = baseLoop.as(Loop.class);
                    loop.setTestBefore(slc.isTestBefore());
                    loop.setHasLoopMaximum(slc.getLoopMaximum() != null);
                    loop.setLoopMaximum(slc.getLoopMaximum() != null ? slc.getLoopMaximum().intValue() : 0);
                    loop.setLoopExpression(BPMN20Loader.buildExpressionFrom(null, slc.getLoopCondition()));
                }
            } else if (value instanceof TMultiInstanceLoopCharacteristics) {
                TMultiInstanceLoopCharacteristics milc = (TMultiInstanceLoopCharacteristics)value;
                activity.setLoopCharacteristicsType(LoopCharacteristicsType.MULTIINSTANCE);
                LoopCharacteristics baseLoop = activity.getLoopCharacteristics();
                if (baseLoop != null) {
                    DataDeclaration dataDeclaration;
                    MultiInstance multiInstance = baseLoop.as(MultiInstance.class);
                    multiInstance.setSequential(milc.isIsSequential());
                    multiInstance.setLoopCardinality(BPMN20Loader.buildExpressionFrom(null, milc.getLoopCardinality()));
                    multiInstance.setCompletionCondition(BPMN20Loader.buildExpressionFrom(null, milc.getCompletionCondition()));
                    SingleDataAssociationFeature data = activity.getFeature(IncomingDataAssociationFeature.class);
                    TDataInput dataInput = milc.getLoopDataInput();
                    if (dataInput != null && (dataDeclaration = this.getDataDeclaration(data, dataInput.getId())) != null) {
                        multiInstance.setLoopDataInput(dataDeclaration);
                    }
                    data = activity.getFeature(OutgoingDataAssociationFeature.class);
                    TDataOutput dataOutput = milc.getLoopDataOutput();
                    if (dataOutput != null && (dataDeclaration = this.getDataDeclaration(data, dataOutput.getId())) != null) {
                        multiInstance.setLoopDataOutput(dataDeclaration);
                    }
                }
            }
        }
    }

    private DataDeclaration getDataDeclaration(SingleDataAssociationFeature dataFeature, String id) {
        DataAssociationSet dataAssociationSet;
        DataDeclaration dataDeclaration = null;
        if (dataFeature != null && id != null && !id.equals("") && (dataAssociationSet = dataFeature.getDataAssociationSet()) != null) {
            dataDeclaration = dataAssociationSet.getArgumentsContainer().findDeclaration(id);
        }
        return dataDeclaration;
    }

    private void loadGatewayData(TGateway tGateway, Gateway gateway) throws ProjectException {
        LoadingFlowNodeHandler loadingFlowNodeHandler = new LoadingFlowNodeHandler(tGateway);
        ModelUtils.handleFlowNodeChecked(gateway, loadingFlowNodeHandler);
        try {
            gateway.setDirection(GatewayDirection.fromValue(Str.capitalize(tGateway.getGatewayDirection().value())));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void loadEventData(TEvent tEvent, Event event) throws ProjectException {
        LoadingFlowNodeHandler loadingFlowNodeHandler = new LoadingFlowNodeHandler(tEvent);
        ModelUtils.handleFlowNodeChecked(event, loadingFlowNodeHandler);
    }

    private void loadDataAssociations(TFlowElement value, FlowNode node) throws ProjectException {
        if (value instanceof TFlowNode) {
            if (value instanceof TEvent) {
                this.loadDataAssociations((TEvent)value, (Event)node);
            } else if (value instanceof TActivity) {
                this.loadDataAssociations((TActivity)value, (Activity)node);
            }
        }
    }

    private void loadDataAssociations(TEvent tEvent, Event event) throws ProjectException {
        if (tEvent instanceof TThrowEvent) {
            this.loadDataAssociations((TThrowEvent)tEvent, (ThrowEvent)event);
        } else if (tEvent instanceof TCatchEvent) {
            this.loadDataAssociations((TCatchEvent)tEvent, (CatchEvent)event);
        }
    }

    private void loadDataAssociations(TThrowEvent tThrowEvent, ThrowEvent throwEvent) throws ProjectException {
        DataAssociationSet inputDataAssociationSet = throwEvent.getInputDataAssociationSet();
        if (inputDataAssociationSet != null) {
            if (throwEvent.getEventTriggerType() != EventTriggerType.NONE) {
                ProcessArgumentContainer argumentsContainer = new ProcessArgumentContainer(throwEvent.getProject());
                this.loadDataInputs((DataDeclarationContainer)argumentsContainer, tThrowEvent.getDataInput());
                throwEvent.setInputArgumentsContainer((DataDeclarationContainer)argumentsContainer);
            }
            BPMN20Loader.loadInputDataAssociations(inputDataAssociationSet, tThrowEvent.getDataInputAssociation());
        }
    }

    private void loadDataAssociations(TCatchEvent tCatchEvent, CatchEvent catchEvent) throws ProjectException {
        DataAssociationSet outputDataAssociationSet = catchEvent.getOutputDataAssociationSet();
        if (outputDataAssociationSet != null) {
            if (catchEvent.getEventTriggerType() != EventTriggerType.NONE) {
                ProcessArgumentContainer argumentsContainer = new ProcessArgumentContainer(catchEvent.getProject());
                this.loadDataOutputs((DataDeclarationContainer)argumentsContainer, tCatchEvent.getDataOutput());
                catchEvent.setOutputArgumentsContainer((DataDeclarationContainer)argumentsContainer);
            }
            BPMN20Loader.loadOutputDataAssociations(outputDataAssociationSet, tCatchEvent.getDataOutputAssociation());
        }
    }

    private void loadDataOutputs(DataDeclarationContainer outputArgumentsContainer, List<TDataOutput> dataOutputs) throws ProjectException {
        for (TDataOutput tDataOutput : dataOutputs) {
            CatalogType catalogType;
            TTypeRef ref = this.getTTypeRef(tDataOutput);
            if (ref != null) {
                catalogType = this.getCatalogTypeFrom(ref, false);
            } else {
                String type = tDataOutput.getStructureDefinitionRef().getLocalPart();
                catalogType = this.createCatalogTypeFromTypeName(type);
            }
            DataDeclaration outputArgument = outputArgumentsContainer.createDeclaration(tDataOutput.getName(), catalogType);
            outputArgumentsContainer.addDeclaration(outputArgument);
        }
    }

    private TTypeRef getTTypeRef(TBaseElement tDataOutput) {
        TOracleExtensions tOracleExtensions = IoUtils.getOracleExtensionsFrom(tDataOutput);
        TTypeRef ref = null;
        if (tOracleExtensions != null) {
            ref = tOracleExtensions.getTypeRef();
        }
        return ref;
    }

    private void loadDataInputs(DataDeclarationContainer inputArgumentsContainer, List<TDataInput> dataInputs) throws ProjectException {
        for (TDataInput tDataInput : dataInputs) {
            CatalogType catalogType;
            TTypeRef ref = this.getTTypeRef(tDataInput);
            if (ref != null) {
                catalogType = this.getCatalogTypeFrom(ref, false);
            } else {
                String type = tDataInput.getStructureDefinitionRef().getLocalPart();
                catalogType = this.createCatalogTypeFromTypeName(type);
            }
            DataDeclaration inputArgument = inputArgumentsContainer.createDeclaration(tDataInput.getName(), catalogType);
            inputArgumentsContainer.addDeclaration(inputArgument);
        }
    }

    private void loadDataAssociations(TActivity tActivity, Activity activity) throws ProjectException {
        ProcessArgumentContainer argumentsContainer;
        TInputOutputSpecification tInputOutputSpecification;
        if (activity instanceof InputDataAssociationEnabled) {
            InputDataAssociationEnabled inputActivity = (InputDataAssociationEnabled)((Object)activity);
            DataAssociationSet inputDataAssociationSet = inputActivity.getInputDataAssociationSet();
            if (this.activityHasUserDefinedInputs(activity) && (tInputOutputSpecification = tActivity.getIoSpecification()) != null) {
                argumentsContainer = new ProcessArgumentContainer(activity.getProject());
                this.loadDataInputs((DataDeclarationContainer)argumentsContainer, tInputOutputSpecification.getDataInput());
                inputActivity.setInputArgumentsContainer((DataDeclarationContainer)argumentsContainer);
            }
            BPMN20Loader.loadInputDataAssociations(inputDataAssociationSet, tActivity.getDataInputAssociation());
        }
        if (activity instanceof OutputDataAssociationEnabled) {
            OutputDataAssociationEnabled outputActivity = (OutputDataAssociationEnabled)((Object)activity);
            DataAssociationSet outputDataAssociationSet = outputActivity.getOutputDataAssociationSet();
            if (this.activityHasUserDefinedOutputs(activity) && (tInputOutputSpecification = tActivity.getIoSpecification()) != null) {
                argumentsContainer = new ProcessArgumentContainer(activity.getProject());
                this.loadDataOutputs((DataDeclarationContainer)argumentsContainer, tInputOutputSpecification.getDataOutput());
                outputActivity.setOutputArgumentsContainer((DataDeclarationContainer)argumentsContainer);
            }
            BPMN20Loader.loadOutputDataAssociations(outputDataAssociationSet, tActivity.getDataOutputAssociation());
        }
    }

    private boolean activityHasUserDefinedInputs(Activity activity) {
        return activity.isSubprocess() || activity.isCallActivity() || activity.isSendTask();
    }

    private boolean activityHasUserDefinedOutputs(Activity activity) {
        return activity.isSubprocess() || activity.isCallActivity() || activity.isReceiveTask();
    }

    private void loadDataAssociations(TProcess tProcess) throws ProjectException {
        TInputOutputSpecification tInputOutputSpecification;
        if (this.process.isCallableSubprocess() && (tInputOutputSpecification = tProcess.getIoSpecification()) != null) {
            ProcessArgumentContainer inputArgumentsContainer = new ProcessArgumentContainer(this.process.getProject());
            this.loadDataInputs((DataDeclarationContainer)inputArgumentsContainer, tInputOutputSpecification.getDataInput());
            this.process.setInputArgumentsContainer((DataDeclarationContainer)inputArgumentsContainer);
            ProcessArgumentContainer outputArgumentsContainer = new ProcessArgumentContainer(this.process.getProject());
            this.loadDataOutputs((DataDeclarationContainer)outputArgumentsContainer, tInputOutputSpecification.getDataOutput());
            this.process.setOutputArgumentsContainer((DataDeclarationContainer)outputArgumentsContainer);
        }
    }

    private CatalogMember getOperationFrom(String participantName, String operationSignature) {
        Project project = this.nodeContainer.getProject();
        CatalogObject participant = null;
        CatalogMember operation = null;
        if (project != null && project.getComponentCatalog() != null) {
            try {
                participant = project.findCatalogObject(participantName);
            }
            catch (AmbiguousTypeNameException e) {
                e.printStackTrace();
            }
            if (participant != null) {
                operation = participant.findMember(operationSignature);
            }
        }
        return operation;
    }

    @Deprecated
    @Nullable
    private ErrorObject getErrorObjectFrom(@NotNull String textId) {
        CatalogObject catalogObject = this.findCatalogObjectUsing(textId);
        ErrorObject errorObject = null;
        if (catalogObject instanceof ErrorObject) {
            errorObject = (ErrorObject)catalogObject;
        }
        return errorObject;
    }

    @Nullable
    private SignalObject getSignalObjectFrom(@NotNull String textId) {
        CatalogObject catalogObject = this.findCatalogObjectUsing(textId);
        SignalObject signalObject = null;
        if (catalogObject instanceof SignalObject) {
            signalObject = (SignalObject)catalogObject;
        }
        return signalObject;
    }

    @Nullable
    private CatalogObject findCatalogObjectUsing(@NotNull String textId) {
        Project project = this.nodeContainer.getProject();
        CatalogObject catalogObject = null;
        if (project != null && project.getComponentCatalog() != null) {
            try {
                catalogObject = project.findCatalogObject(textId);
            }
            catch (AmbiguousTypeNameException e) {
                e.printStackTrace();
            }
        }
        return catalogObject;
    }

    private CatalogObject getCatalogObjectFor(String catalogObjectName) {
        Project project = this.nodeContainer.getProject();
        CatalogObject catalogObject = null;
        if (project != null && project.getComponentCatalog() != null) {
            try {
                catalogObject = project.findCatalogObject(catalogObjectName);
            }
            catch (AmbiguousTypeNameException e) {
                e.printStackTrace();
            }
        }
        return catalogObject;
    }

    private SequenceFlow createSequenceFlowFrom(TSequenceFlow tSequenceFlow) throws ProjectException {
        SequenceFlow sequenceFlow = this.nodeContainer.createSequenceFlow();
        sequenceFlow.setId(tSequenceFlow.getId());
        FlowNode source = this.nodeContainer.findNode(((TFlowElement)tSequenceFlow.getSourceRef()).getId());
        FlowNode target = this.nodeContainer.findNode(((TFlowElement)tSequenceFlow.getTargetRef()).getId());
        if (source == null || target == null) {
            return null;
        }
        sequenceFlow.setSource(source);
        sequenceFlow.setTarget(target);
        this.nodeContainer.addChild(sequenceFlow);
        if (tSequenceFlow.getConditionExpression() != null) {
            sequenceFlow.toConditionalFlow();
        }
        return sequenceFlow;
    }

    private Event createEventFrom(TEvent tEvent) throws ProjectException {
        Event event;
        if (tEvent instanceof TStartEvent) {
            event = this.nodeContainer.createStartEvent(this.getTriggerType(((TStartEvent)tEvent).getEventDefinition()));
        } else if (tEvent instanceof TEndEvent) {
            event = this.nodeContainer.createEndEvent(this.getTriggerType(((TEndEvent)tEvent).getEventDefinition()));
        } else if (tEvent instanceof TIntermediateCatchEvent) {
            event = this.nodeContainer.createIntermediateCatchEvent(this.getTriggerType(((TIntermediateCatchEvent)tEvent).getEventDefinition()));
        } else if (tEvent instanceof TIntermediateThrowEvent) {
            event = this.nodeContainer.createIntermediateThrowEvent(this.getTriggerType(((TIntermediateThrowEvent)tEvent).getEventDefinition()));
        } else if (tEvent instanceof TBoundaryEvent) {
            event = this.nodeContainer.createBoundaryEvent(this.getTriggerType(((TBoundaryEvent)tEvent).getEventDefinition()), null);
        } else {
            throw ProjectException.wrap((ProjectObject)this.nodeContainer, BPMN20Loader.getUnexpectedElementException(tEvent));
        }
        event.setId(tEvent.getId());
        event.setDefaultLabel(tEvent.getName());
        this.nodeContainer.addChild(event);
        return event;
    }

    private EventTriggerType getTriggerType(JAXBElement<? extends TEventDefinition> trigger) {
        return this.getEventTriggerTypeFor(trigger != null ? (TEventDefinition)trigger.getValue() : null);
    }

    private EventTriggerType getEventTriggerTypeFor(TEventDefinition tEventDefinition) {
        if (tEventDefinition instanceof TMessageEventDefinition) {
            return EventTriggerType.MESSAGE;
        }
        if (tEventDefinition instanceof TErrorEventDefinition) {
            return EventTriggerType.ERROR;
        }
        if (tEventDefinition instanceof TTimerEventDefinition) {
            return EventTriggerType.TIMER;
        }
        if (tEventDefinition instanceof TSignalEventDefinition) {
            return EventTriggerType.SIGNAL;
        }
        if (tEventDefinition instanceof TTerminateEventDefinition) {
            return EventTriggerType.TERMINATE;
        }
        if (tEventDefinition == null) {
            return EventTriggerType.NONE;
        }
        throw new IllegalArgumentException("Unknown EventDefinition->" + tEventDefinition);
    }

    private Gateway createGatewayFrom(TGateway tGateway) throws ProjectException {
        Gateway gateway;
        if (tGateway instanceof TParallelGateway) {
            gateway = this.nodeContainer.createParallelGateway();
        } else if (tGateway instanceof TExclusiveGateway) {
            gateway = this.nodeContainer.createExclusiveGateway();
        } else if (tGateway instanceof TInclusiveGateway) {
            gateway = this.nodeContainer.createInclusiveGateway();
        } else if (tGateway instanceof TComplexGateway) {
            gateway = this.nodeContainer.createComplexGateway();
        } else if (tGateway instanceof TEventBasedGateway) {
            gateway = this.nodeContainer.createEventBasedGateway();
        } else {
            throw ProjectException.wrap((ProjectObject)this.nodeContainer, BPMN20Loader.getUnexpectedElementException(tGateway));
        }
        gateway.setId(tGateway.getId());
        gateway.setDefaultLabel(tGateway.getName());
        this.nodeContainer.addChild(gateway);
        return gateway;
    }

    private Activity createActivityFrom(TActivity tActivity) throws ProjectException {
        Activity activity;
        if (tActivity instanceof TSubProcess) {
            TSubProcess tSubprocess = (TSubProcess)tActivity;
            activity = this.nodeContainer.createSubprocess(tSubprocess.isTriggeredByEvent());
        } else {
            activity = this.nodeContainer.createActivity();
            this.loadLane(activity, tActivity);
            if (tActivity instanceof TUserTask) {
                activity = activity.toUserTask();
            } else if (tActivity instanceof TServiceTask) {
                activity = activity.toServiceTask();
            } else if (tActivity instanceof TScriptTask) {
                activity = activity.toScriptTask();
            } else if (tActivity instanceof TReceiveTask) {
                activity = activity.toReceiveTask();
            } else if (tActivity instanceof TSendTask) {
                activity = activity.toSendTask();
            } else if (tActivity instanceof TCallActivity) {
                activity = activity.toCallActivity();
            } else if (tActivity instanceof TManualTask) {
                activity = activity.toManualTask();
            } else if (tActivity instanceof TBusinessRuleTask) {
                activity = activity.toBusinessRuleTask();
            }
        }
        activity.setId(tActivity.getId());
        activity.setDefaultLabel(tActivity.getName());
        this.nodeContainer.addChild(activity);
        return activity;
    }

    private void loadLane(Activity activity, TActivity tActivity) {
        List<JAXBElement<? extends TPerformer>> elementList = tActivity.getPerformer();
        if (elementList != null) {
            for (JAXBElement<? extends TPerformer> jaxbElement : elementList) {
                String laneId;
                Lane lane;
                TPerformer performer = (TPerformer)jaxbElement.getValue();
                if (performer == null || (lane = this.process.findLane(laneId = performer.getId())) == null) continue;
                activity.setLane(lane);
            }
        }
    }

    private TEventDefinition getEventDefinition(TEvent tEvent) {
        JAXBElement<? extends TEventDefinition> element = null;
        if (tEvent instanceof TCatchEvent) {
            element = ((TCatchEvent)tEvent).getEventDefinition();
        } else if (tEvent instanceof TThrowEvent) {
            element = ((TThrowEvent)tEvent).getEventDefinition();
        }
        return element != null ? (TEventDefinition)element.getValue() : null;
    }

    private void processEventDefinition(TEvent tEvent, Event event) throws ProjectException {
        ModelUtils.handleEventTriggerChecked(event, new LoadingEventDefinitionHandler(tEvent));
    }

    private class LoadingFlowNodeHandler
    extends CheckedFlowNodeAdapter {
        private TActivity tActivity;
        private TEvent tEvent;
        private TGateway tGateway;

        public LoadingFlowNodeHandler(TActivity tActivity) {
            this.tActivity = tActivity;
        }

        public LoadingFlowNodeHandler(TEvent tEvent) {
            this.tEvent = tEvent;
        }

        public LoadingFlowNodeHandler(TGateway tGateway) {
            this.tGateway = tGateway;
        }

        @Override
        public void handleStartEvent(StartEvent startEvent) throws ProjectException {
            TStartEvent tStartEvent = (TStartEvent)this.tEvent;
            startEvent.setIsInterrupting(tStartEvent.isIsInterrupting());
            BPMN20Loader.this.processEventDefinition(this.tEvent, startEvent);
        }

        @Override
        public void handleEndEvent(EndEvent endEvent) throws ProjectException {
            BPMN20Loader.this.processEventDefinition(this.tEvent, endEvent);
        }

        @Override
        public void handleIntermediateThrowEvent(ThrowEvent intThrow) throws ProjectException {
            BPMN20Loader.this.processEventDefinition(this.tEvent, intThrow);
        }

        @Override
        public void handleCatchIntermediateEvent(CatchEvent intCatch) throws ProjectException {
            BPMN20Loader.this.processEventDefinition(this.tEvent, intCatch);
        }

        @Override
        public void handleServiceTask(ServiceTask serviceTask) throws ProjectException {
            CatalogMember operation;
            String serviceName;
            TServiceTask tServiceTask = (TServiceTask)this.tActivity;
            String operationSignature = tServiceTask.getOperationRef() != null ? tServiceTask.getOperationRef().getLocalPart() : null;
            String string = serviceName = tServiceTask.getServiceRef() != null ? tServiceTask.getServiceRef().getLocalPart() : null;
            if (operationSignature != null && serviceName != null && (operation = BPMN20Loader.this.getOperationFrom(serviceName, operationSignature)) != null) {
                serviceTask.setOperation(operation);
            }
        }

        @Override
        public void handleSendTask(SendTask sendTask) throws ProjectException {
            CatalogMember operation;
            String participantName;
            TSendTask tSendTask = (TSendTask)this.tActivity;
            String operationSignature = tSendTask.getOperationRef() != null ? tSendTask.getOperationRef().getLocalPart() : null;
            String string = participantName = tSendTask.getMessageRef() != null ? tSendTask.getMessageRef().getLocalPart() : null;
            if (operationSignature != null && participantName != null && (operation = BPMN20Loader.this.getOperationFrom(participantName, operationSignature)) != null) {
                sendTask.setOperation(operation);
            }
        }

        @Override
        public void handleScriptTask(ScriptTask serviceTask) throws ProjectException {
            TScriptTask tScriptTask = (TScriptTask)this.tActivity;
            serviceTask.setLanguage(tScriptTask.getScriptLanguage());
            TScript script = tScriptTask.getScript();
            List<Object> content = script.getContent();
            serviceTask.setScript(!content.isEmpty() && content.get(0) instanceof String ? (String)content.get(0) : "");
        }

        @Override
        public void handleReceiveTask(ReceiveTask receiveTask) throws ProjectException {
            CatalogMember operation;
            String participantName;
            TReceiveTask tReceiveTask = (TReceiveTask)this.tActivity;
            receiveTask.setInstantiate(tReceiveTask.isInstantiate());
            String operationSignature = tReceiveTask.getOperationRef() != null ? tReceiveTask.getOperationRef().getLocalPart() : null;
            String string = participantName = tReceiveTask.getMessageRef() != null ? tReceiveTask.getMessageRef().getLocalPart() : null;
            if (operationSignature != null && participantName != null && (operation = BPMN20Loader.this.getOperationFrom(participantName, operationSignature)) != null) {
                receiveTask.setOperation(operation);
            }
        }

        @Override
        public void handleUserTask(UserTask userTask) throws ProjectException {
            TUserTask tUserTask = (TUserTask)this.tActivity;
            THumanTask tHumanTask = IoUtils.getNamedOracleExtension(THumanTask.class, tUserTask);
            if (tHumanTask != null) {
                CatalogObject cObj;
                String humanTaskName = tHumanTask.getHumanTaskReference();
                if (humanTaskName != null && (cObj = BPMN20Loader.this.getCatalogObjectFor(humanTaskName)) != null && cObj instanceof HumanTask) {
                    userTask.setHumanTask((HumanTask)cObj);
                }
                userTask.setUsesTransformations(tHumanTask.isUsesTransformations());
            }
        }

        @Override
        public void handleBusinessRuleTask(BusinessRuleTask businessRuleTask) throws ProjectException {
            TBusinessRuleTask tBusinessRuleTask = (TBusinessRuleTask)this.tActivity;
            TBusinessRuleTaskData tBusinessRuleTaskData = IoUtils.getNamedOracleExtension(TBusinessRuleTaskData.class, tBusinessRuleTask);
            if (tBusinessRuleTaskData != null) {
                String businessRuleName = tBusinessRuleTaskData.getBusinessRuleName();
                String functionName = tBusinessRuleTaskData.getFunctionName();
                businessRuleTask.setBusinessRule((BusinessRule)BPMN20Loader.this.getCatalogObjectFor(businessRuleName));
                businessRuleTask.setFunction(BPMN20Loader.this.getOperationFrom(businessRuleName, functionName));
            }
        }

        @Override
        public void handleSubprocess(Subprocess subprocess) throws ProjectException {
        }

        @Override
        public void handleCallActivity(CallActivity callActivity) throws ProjectException {
            String calledElementId;
            TCallActivity tCallActivity = (TCallActivity)this.tActivity;
            QName calledElement = tCallActivity.getCalledElement();
            if (calledElement != null && (calledElementId = calledElement.getLocalPart()) != null) {
                callActivity.setCalledElementName(calledElementId);
            }
        }

        @Override
        public void handleManualTask(ManualTask manualTask) throws ProjectException {
        }

        @Override
        public void handleBoundaryEvent(BoundaryEvent boundaryEvent) throws ProjectException {
            Activity activity;
            String attachedToActId;
            TBoundaryEvent tBoundaryEvent = (TBoundaryEvent)this.tEvent;
            boundaryEvent.setCancelActivity(tBoundaryEvent.isCancelActivity());
            String string = attachedToActId = tBoundaryEvent.getAttachedToRef() != null ? tBoundaryEvent.getAttachedToRef().getLocalPart() : null;
            if (attachedToActId != null && (activity = BPMN20Loader.this.nodeContainer.findActivity(attachedToActId)) != null) {
                boundaryEvent.setBoundaryActivity(activity);
            }
            BPMN20Loader.this.processEventDefinition(tBoundaryEvent, boundaryEvent);
        }

        @Override
        public void handleComplexGateway(ComplexGateway complexGateway) throws ProjectException {
            TComplexGateway tComplexGateway = (TComplexGateway)this.tGateway;
            complexGateway.setActivationCondition(BPMN20Loader.buildExpressionFrom(null, tComplexGateway.getActivationCondition()));
        }

        @Override
        public void handleEventBasedGateway(EventBasedGateway eventBasedGateway) throws ProjectException {
            TEventBasedGateway tEventBasedGateway = (TEventBasedGateway)this.tGateway;
            eventBasedGateway.setInstantiate(tEventBasedGateway.isInstantiate());
            try {
                eventBasedGateway.setType(EventBasedGatewayType.fromValue(Str.capitalize(tEventBasedGateway.getEventGatewayType().value())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class LoadingEventDefinitionHandler
    extends CheckedEventTriggerAdapter {
        private TEvent tEvent;

        LoadingEventDefinitionHandler(TEvent tEvent) {
            this.tEvent = tEvent;
        }

        public TEvent getTEventRef() {
            return this.tEvent;
        }

        @Override
        public void handleMessageEvent(Event event) throws ProjectException {
            TMessageEventDefinition tMessageEventDefinition = (TMessageEventDefinition)BPMN20Loader.this.getEventDefinition(this.tEvent);
            if (tMessageEventDefinition != null) {
                TErrorEventDefinition tErrorEventDefinition;
                MessageEventDefinition messageEventDefinition = event.getEventDefinition().as(MessageEventDefinition.class);
                QName operationRef = tMessageEventDefinition.getOperationRef();
                if (operationRef != null) {
                    CatalogMember operation;
                    String operationName = operationRef.getLocalPart();
                    TParticipant tParticipant = IoUtils.getNamedOracleExtension(TParticipant.class, this.tEvent);
                    if (tParticipant != null && (operation = BPMN20Loader.this.getOperationFrom(tParticipant.getId(), operationName)) != null) {
                        ConversationEnabled conversationalEvent = (ConversationEnabled)((Object)event);
                        conversationalEvent.setOperation(operation);
                    }
                }
                if (event.isThrowEvent() && (tErrorEventDefinition = IoUtils.getUnnamedOracleExtension(TErrorEventDefinition.class, tMessageEventDefinition)) != null) {
                    this.handleErrorEventStructures(tErrorEventDefinition, messageEventDefinition.getErrorEventDefinition());
                }
            }
        }

        @Override
        public void handleErrorEvent(Event event) throws ProjectException {
            TErrorEventDefinition tErrorEventDefinition = (TErrorEventDefinition)BPMN20Loader.this.getEventDefinition(this.tEvent);
            EventDefinition eventDefinition = event.getEventDefinition();
            this.handleErrorEventStructures(tErrorEventDefinition, eventDefinition);
        }

        @Override
        public void handleTimerEvent(Event event) throws ProjectException {
            TTimerEventDefinition tTimerEventDefinition = (TTimerEventDefinition)BPMN20Loader.this.getEventDefinition(this.tEvent);
            if (tTimerEventDefinition != null) {
                TimerEventDefinition definition = event.getEventDefinition().as(TimerEventDefinition.class);
                TExpression cycleExpression = tTimerEventDefinition.getTimeCycle();
                TExpression dateExpression = tTimerEventDefinition.getTimeDate();
                if (cycleExpression != null) {
                    String cycle = IoUtils.getExpressionStringContent(cycleExpression);
                    if (cycleExpression instanceof TFormalExpression) {
                        TFormalExpression cycleFormalExpression = (TFormalExpression)cycleExpression;
                        String language = cycleFormalExpression.getLanguage();
                        ExpressionLanguage expLanguage = null;
                        if (language != null) {
                            expLanguage = ExpressionLanguage.fromId((String)language);
                        }
                        if (expLanguage != null) {
                            definition.setTimeCycleExpression(BPMN20Loader.buildExpressionFrom(tTimerEventDefinition, cycleFormalExpression));
                        } else if (cycle != null) {
                            if (cycle.startsWith("'") && cycle.endsWith("'")) {
                                definition.setTimeCycleExpression((Expression)new XPathExpression(cycle));
                            } else {
                                definition.setTimeCycleExpression((Expression)XPathExpression.createConstantExpression((String)cycle));
                            }
                        }
                    } else {
                        definition.setTimeCycleExpression(BPMN20Loader.buildExpressionFrom(tTimerEventDefinition, cycleExpression));
                    }
                } else if (dateExpression != null) {
                    String date = IoUtils.getExpressionStringContent(dateExpression);
                    if (dateExpression instanceof TFormalExpression) {
                        TFormalExpression dateFormalExpression = (TFormalExpression)dateExpression;
                        String language = dateFormalExpression.getLanguage();
                        ExpressionLanguage expLanguage = null;
                        if (language != null) {
                            expLanguage = ExpressionLanguage.fromId((String)language);
                        }
                        if (expLanguage != null) {
                            definition.setTimeDateExpression(BPMN20Loader.buildExpressionFrom(tTimerEventDefinition, dateFormalExpression));
                        } else if (date != null) {
                            if (date.startsWith("'") && date.endsWith("'")) {
                                definition.setTimeDateExpression((Expression)new XPathExpression(date));
                            } else {
                                definition.setTimeDateExpression((Expression)XPathExpression.createConstantExpression((String)date));
                            }
                        }
                    } else {
                        definition.setTimeDateExpression(BPMN20Loader.buildExpressionFrom(tTimerEventDefinition, dateExpression));
                    }
                }
            }
        }

        @Override
        public void handleSignalEvent(Event event) throws ProjectException {
            TSignalEventDefinition tSignalEventDefinition = (TSignalEventDefinition)BPMN20Loader.this.getEventDefinition(this.tEvent);
            if (tSignalEventDefinition != null) {
                SignalEventDefinition signalEventDefinition = event.getEventDefinition().as(SignalEventDefinition.class);
                QName signalRef = tSignalEventDefinition.getSignalRef();
                if (signalRef != null) {
                    String signalName = signalRef.getLocalPart();
                    signalEventDefinition.setSignal(BPMN20Loader.this.getSignalObjectFrom(signalName));
                }
                TFormalExpression expression = IoUtils.getUnnamedOracleExtension(TFormalExpression.class, tSignalEventDefinition);
                signalEventDefinition.setExpression(BPMN20Loader.buildExpressionFrom(tSignalEventDefinition, expression));
            }
        }

        private void handleErrorEventStructures(TErrorEventDefinition tErrorEventDefinition, EventDefinition eventDefinition) {
            if (tErrorEventDefinition != null && eventDefinition != null) {
                TTypeRef ref = BPMN20Loader.this.getTTypeRef(tErrorEventDefinition);
                ErrorObject errorObject = null;
                String errorCode = tErrorEventDefinition.getErrorCode();
                if (ref != null) {
                    CatalogType catalogType = BPMN20Loader.this.getCatalogTypeFrom(ref, true);
                    if (catalogType != null && catalogType.isException()) {
                        errorObject = (ErrorObject)catalogType;
                    }
                } else if (!Str.isEmpty(errorCode)) {
                    errorObject = BPMN20Loader.this.getErrorObjectFrom(errorCode);
                }
                ErrorEventDefinition errorEventDefinition = eventDefinition.as(ErrorEventDefinition.class);
                if (errorObject != null) {
                    errorEventDefinition.setError(errorObject);
                }
                errorEventDefinition.setErrorCode(errorCode);
            }
        }
    }
}

