/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentTransition;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.transitions.ConditionalTransitionFeature;
import oracle.bpm.project.model.processes.transitions.TransitionMethodFeature;

public class PureXpdlTransitionsInterpreter {
    public SequenceFlow createTransitionFrom(PersistentTransition persistentTransition, Process model) throws ProjectException {
        SequenceFlow transition;
        PersistentTransition.Type xpdlTransitionType = persistentTransition.getXpdlTransitionType();
        switch (xpdlTransitionType) {
            case CONDITION: {
                transition = model.createSequenceFlow();
                this.addCondition(transition, persistentTransition);
                break;
            }
            default: {
                transition = model.createSequenceFlow();
            }
        }
        transition.setId(persistentTransition.getId());
        persistentTransition.addTo(transition);
        return transition;
    }

    private void addCondition(SequenceFlow transition, PersistentTransition persistentTransition) {
        TransitionMethodFeature methodFeature = transition.getFeature(ConditionalTransitionFeature.class);
        methodFeature.setValue((Expression)new XPathExpression(persistentTransition.getCondition().getText()));
    }
}

