/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import java.util.Map;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAlbpmExtensions;
import oracle.bpm.project.io.serializers.model.albpm.PersistentComponent;
import oracle.bpm.project.io.serializers.model.albpm.PersistentCorrelationSets;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFeatureSet;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalization;
import oracle.bpm.project.io.serializers.model.albpm.PersistentMeasurements;
import oracle.bpm.project.io.serializers.model.albpm.PersistentNotes;
import oracle.bpm.project.io.serializers.model.albpm.PersistentWebServices;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.Extensions;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentActivities;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentActivity;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentActivitySet;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentActivitySets;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentApplications;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBaseProcessType;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPackageType;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentProcessHeader;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentRedefinableHeader;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentTransitions;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.Element;

public class PersistentProcessType
extends PersistentBaseProcessType {
    @Override
    public PersistentProcessHeader getProcessHeader() {
        PersistentProcessHeader processHeader = super.getProcessHeader();
        if (processHeader == null) {
            processHeader = new PersistentProcessHeader();
            this.setProcessHeader(processHeader);
        }
        return processHeader;
    }

    @Override
    public PersistentRedefinableHeader getRedefinableHeader() {
        PersistentRedefinableHeader redefinableHeader = super.getRedefinableHeader();
        if (redefinableHeader == null) {
            redefinableHeader = new PersistentRedefinableHeader();
            this.setRedefinableHeader(redefinableHeader);
        }
        return redefinableHeader;
    }

    @Override
    public PersistentActivities getActivities() {
        PersistentActivities activities = super.getActivities();
        if (activities == null) {
            activities = new PersistentActivities();
            this.setActivities(activities);
        }
        return activities;
    }

    @Override
    public PersistentApplications getApplications() {
        PersistentApplications applications = super.getApplications();
        if (applications == null) {
            applications = new PersistentApplications();
            this.setApplications(applications);
        }
        return applications;
    }

    @Override
    public PersistentTransitions getTransitions() {
        PersistentTransitions transitions = super.getTransitions();
        if (transitions == null) {
            transitions = new PersistentTransitions();
            this.setTransitions(transitions);
        }
        return transitions;
    }

    @Override
    public DefaultElement getExtensions() {
        DefaultElement extensions = super.getExtensions();
        if (extensions == null) {
            extensions = new Extensions();
            this.setExtensions(extensions);
        }
        return extensions;
    }

    public PersistentAlbpmExtensions getAlbpmExtensions() {
        DefaultElement extensions = this.getExtensions();
        PersistentAlbpmExtensions albpmExtensions = this.getAlbpmExtensionsFromExtensions();
        if (albpmExtensions == null) {
            albpmExtensions = new PersistentAlbpmExtensions();
            extensions.addChild((Element)albpmExtensions);
        }
        return albpmExtensions;
    }

    @Override
    public PersistentActivitySets getActivitySets() {
        PersistentActivitySets activitySets = (PersistentActivitySets)this.getElementByClass(PersistentActivitySets.class);
        if (activitySets == null) {
            activitySets = new PersistentActivitySets();
            this.addChild((Element)activitySets);
        }
        return activitySets;
    }

    @Override
    public void addTo(Process model) throws ProjectException {
        PersistentLocalization persistentLocalization;
        PersistentFeatureSet persistentFeatureSet;
        PersistentCorrelationSets persistentCorrelationSets;
        model.setId(this.getName());
        boolean hasXpdlExtensions = this.hasXpdlExtensions();
        PersistentComponent persistentComponent = this.getAlbpmExtensions().getComponent();
        if (persistentComponent != null) {
            persistentComponent.addToComponent(model);
        }
        if ((persistentCorrelationSets = this.getAlbpmExtensions().getCorrelationSets()) != null) {
            persistentCorrelationSets.addCorrelationSets(model);
        }
        if ((persistentFeatureSet = this.getAlbpmExtensions().getFeatureSet()) != null) {
            Map<String, Object> map = persistentFeatureSet.buildFeaturesMap();
            Features modelFeatures = model.getFeatures();
            for (PersistentFeature modelFeature : modelFeatures.persistentFeatures()) {
                modelFeature.fill(map);
            }
        }
        if ((persistentLocalization = this.getAlbpmExtensions().getLocalization()) != null) {
            persistentLocalization.addTo(model.getLabelMap(), model.getDescriptionMap(), model.getDocumentationMap(), model.getUseCaseDocumentationMap());
        }
        if (hasXpdlExtensions) {
            PersistentWebServices persistentWebServices;
            PersistentMeasurements persistentMeasurements;
            PersistentRedefinableHeader redefinableHeader = this.getRedefinableHeader();
            if (redefinableHeader != null) {
                redefinableHeader.addTo(model);
            }
            if ((persistentMeasurements = this.getAlbpmExtensions().getMeasurements()) != null) {
                persistentMeasurements.addTo(model);
            }
            if ((persistentWebServices = this.getAlbpmExtensions().getWebServices()) != null) {
                persistentWebServices.addTo(model);
            }
            super.addTo(model);
            PersistentNotes persistentNotes = this.getAlbpmExtensions().getNotes();
            if (persistentNotes != null) {
                persistentNotes.addTo(model);
            }
        } else {
            super.addTo(model);
        }
        this.ensureAutomaticHandlerCreated(model);
    }

    public PersistentActivity findActivity(FlowNode nodeRef) {
        String activityId = nodeRef.getId();
        PersistentActivity activity = this.getActivities().findActivity(activityId);
        if (activity == null) {
            PersistentActivitySet activitySet;
            PersistentActivitySet[] arr$ = this.getActivitySets().getActivitySet();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (activity = (activitySet = arr$[i$]).getActivities().findActivity(activityId)) == null; ++i$) {
            }
        }
        return activity;
    }

    PersistentActivitySet findActivitySet(String activitySetId) {
        return this.getActivitySets() != null ? this.getActivitySets().findActivitySet(activitySetId) : null;
    }

    private void ensureAutomaticHandlerCreated(Process process) {
        if (this.getPackage().getPools() == null || !this.getPackage().getPools().hasLanes()) {
            ModelUtils.findOrCreateAutomaticLane(process);
        }
    }

    private PersistentPackageType getPackage() {
        return (PersistentPackageType)this.findAncestorByClass(PersistentPackageType.class);
    }

    private PersistentAlbpmExtensions getAlbpmExtensionsFromExtensions() {
        DefaultElement extensions = this.getExtensions();
        PersistentAlbpmExtensions albpmExtensions = (PersistentAlbpmExtensions)extensions.getElementByClass(PersistentAlbpmExtensions.class);
        if (albpmExtensions == null) {
            albpmExtensions = (PersistentAlbpmExtensions)this.getElementByClass(PersistentAlbpmExtensions.class);
        }
        return albpmExtensions;
    }

    private boolean hasXpdlExtensions() {
        return super.getExtensions() != null;
    }
}

