/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import java.io.Reader;
import oracle.bpm.lang.Time;
import oracle.bpm.project.io.serializers.model.albpm.AlbpmElementFactory;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBasePackageType;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentConformanceClass;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentElementParser;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentGraphConformance;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPackageHeader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.xmlparser.ElementFactory;
import oracle.bpm.xmlparser.ParserException;

public class PersistentPackageType
extends PersistentBasePackageType {
    public static String ALBPM_TOOL_ID = "ALBPM";
    public static String ALBPM_XPDL20_NS = "http://www.albpm.com/2007/albpm.XPDL2";
    public static String XPDL20_NS = "http://www.wfmc.org/2004/XPDL2.0alpha";
    public static String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema-instance";

    public static PersistentPackageType getNewPackageType() {
        PersistentPackageType pt = new PersistentPackageType();
        pt.setPackageHeader(PersistentPackageHeader.getNewPackageHeader());
        pt.getNSContext().addNamespace("xsi", SCHEMA_NS);
        pt.getNSContext().addNamespace("albpm", ALBPM_XPDL20_NS);
        pt.getNSContext().addNamespace("xpdl", XPDL20_NS);
        PersistentConformanceClass conformanceClass = new PersistentConformanceClass();
        conformanceClass.setGraphConformance(PersistentGraphConformance.NON_BLOCKED);
        pt.setConformanceClass(conformanceClass);
        return pt;
    }

    public static void buildFrom(Reader reader, Process model) throws ProjectException, ParserException {
        try {
            PersistentElementParser elementParser = new PersistentElementParser();
            elementParser.setElementFactory((ElementFactory)new AlbpmElementFactory());
            elementParser.parsePackageType(null, reader).addTo(model);
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Throwable t) {
            throw ProjectException.wrap((ProjectObject)model, t);
        }
    }

    @Override
    public void addTo(Process process) throws ProjectException {
        super.addTo(process);
    }

    public boolean isAlbpmPackage() {
        return this.getPackageHeader().isAlbpmPackageHeader();
    }

    public void setDate(Time creationDate) {
        this.getPackageHeader().setDate(creationDate);
    }
}

