/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import oracle.bpm.geom.Point;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBaseNodeGraphicsInfo;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentCoordinates;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentLane;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPackageType;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPool;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.Positional;

public class PersistentNodeGraphicsInfo
extends PersistentBaseNodeGraphicsInfo {
    public static PersistentNodeGraphicsInfo createAlbpmNodeGraphicsInfo() {
        PersistentNodeGraphicsInfo persistentNodeGraphicsInfo = new PersistentNodeGraphicsInfo();
        persistentNodeGraphicsInfo.setToolId(PersistentPackageType.ALBPM_TOOL_ID);
        return persistentNodeGraphicsInfo;
    }

    @Override
    public PersistentCoordinates getCoordinates() {
        PersistentCoordinates coordinates = super.getCoordinates();
        if (coordinates == null) {
            coordinates = new PersistentCoordinates();
            this.setCoordinates(coordinates);
        }
        return coordinates;
    }

    public void addTo(Positional positional) throws ProjectException {
        this.addTo(positional, this.getLaneId());
    }

    public void addTo(Positional positional, String laneId) throws ProjectException {
        Lane lane = ((ModelObject)((Object)positional)).getProcess().findLane(laneId);
        if (lane == null && this.getPackage() != null && this.getPackage().getPools() != null) {
            String laneName = this.getNameForLaneId(laneId);
            lane = ((ModelObject)((Object)positional)).getProcess().findLane(laneName);
        }
        if (lane != null) {
            positional.setLane(lane);
            PersistentCoordinates coord = super.getCoordinates();
            if (coord != null) {
                positional.setLocation(coord.getLocation());
            }
        }
    }

    public String getNameForLaneId(String laneId) {
        String laneName = null;
        if (this.getPackage().getPools() != null && this.getPackage().getPools().getPool() != null) {
            block0: for (PersistentPool pool : this.getPackage().getPools().getPool()) {
                if (pool.getLanes() == null) continue;
                for (PersistentLane lane : pool.getLanes().getLane()) {
                    if (!lane.getId().equals(laneId)) continue;
                    laneName = lane.getName();
                    continue block0;
                }
            }
        }
        return laneName;
    }

    public Point getLocation() {
        PersistentCoordinates coordinates = this.getCoordinates();
        return coordinates.getLocation();
    }

    public void setLocation(Point location) {
        PersistentCoordinates coordinates = this.getCoordinates();
        coordinates.setLocation(location);
    }

    public boolean hasAlbpmInfo() {
        return this.getToolId() != null && this.getToolId().equals(PersistentPackageType.ALBPM_TOOL_ID);
    }

    public boolean hasLocation() {
        return this.getCoordinates().getXCoordinate() != null && this.getCoordinates().getYCoordinate() != null;
    }

    private PersistentPackageType getPackage() {
        return (PersistentPackageType)this.findAncestorByClass(PersistentPackageType.class);
    }
}

