/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm;

import java.util.Map;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBaseMeasurement;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFeatureSet;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalization;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;

public class PersistentMeasurement
extends PersistentBaseMeasurement {
    public void addTo(Positional.Mutable measurementMutable) {
        MeasurementImpl measurement = (MeasurementImpl)measurementMutable;
        measurement.setLocation(this.getLocation());
        PersistentLocalization localization = this.getLocalization();
        if (localization != null) {
            localization.addTo(measurement.getLabelMap(), measurement.getDescriptionMap(), measurement.getDocumentationMap(), measurement.getUseCaseDocumentationMap());
        }
        this.addPersistentFeatures(measurement);
    }

    @Override
    public PersistentFeatureSet getFeatureSet() {
        PersistentFeatureSet featureSet = super.getFeatureSet();
        if (featureSet == null) {
            featureSet = new PersistentFeatureSet();
            this.setFeatureSet(featureSet);
        }
        return featureSet;
    }

    @Override
    public void addTo(Process process) throws ProjectException {
    }

    private void addPersistentFeatures(MeasurementImpl measurement) {
        Map<String, Object> featuresMap = this.getFeatureSet().buildFeaturesMap();
        Features features = measurement.getFeatures();
        for (PersistentFeature persistentModelFeature : features.persistentFeatures()) {
            persistentModelFeature.fill(featuresMap);
        }
    }
}

