/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import oracle.bpm.lang.ComponentLoadingException;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBaseComponent;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeLoader45;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlparser.Text;

public class PersistentComponent
extends PersistentBaseComponent {
    public void setText(String componentDefinition) {
        this.addChild((Element)new Text(componentDefinition));
    }

    public String getText() {
        String content = ((Text)this.getFirstElement()).getContent();
        return content != null ? content.trim() : content;
    }

    @Override
    public void addTo(Process process) throws ProjectException {
    }

    public void addToComponent(Process process) throws ProjectException {
        try {
            ByteArrayInputStream str = new ByteArrayInputStream(this.getText().getBytes(Literals.DEFAULT_ENCODING));
            ObjectTypeDescription otd = TypeLoader45.createFrom((InputStream)str, (ComponentCatalog)PersistentComponent.getCatalog(process));
            ((ProcessContent)process).setObjectTypeDescription(otd);
            this.addProcessMethodFromComponent((ProcessContent)process, otd);
        }
        catch (UnsupportedEncodingException uee) {
            throw ProjectException.wrap((ProjectObject)process, uee);
        }
        catch (ComponentLoadingException e) {
            throw ProjectException.wrap((ProjectObject)process, e);
        }
    }

    private static MutableComponentCatalog getCatalog(Process process) {
        Project project = process.getProject();
        if (project != null) {
            return (MutableComponentCatalog)project.getComponentCatalog();
        }
        MutableComponentCatalog catalog = TypeUtils.createComponentCatalog((MutableComponentCatalog)TypeUtils.getDefaultCatalog());
        catalog.setWorkingInMemory(true);
        return catalog;
    }

    private void addProcessMethodFromComponent(ProcessContent processContent, ObjectTypeDescription otd) {
        ObjectTypeDescription newOtd = processContent.createInstanceType();
        processContent.setObjectTypeDescription(newOtd);
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription mtd = otd.getMember(i);
        }
    }
}

